/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.etc.action;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.IPreferenceConstants;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.SelectPerspectiveDialog;

/**
 * ѡڥƥ򥢥󥯥饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class OpenPerspectiveAction implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
     */
    public void dispose() {

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
     */
    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        IPerspectiveRegistry reg = PlatformUI.getWorkbench()
                .getPerspectiveRegistry();

        SelectPerspectiveDialog dlg = new SelectPerspectiveDialog(window
                .getShell(), reg);
        dlg.open();
        if (dlg.getReturnCode() == Window.CANCEL)
            return;
        IPerspectiveDescriptor desc = dlg.getSelection();
        if (desc != null) {
            run(desc);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see PerspectiveMenu#run(IPerspectiveDescriptor)
     */
    protected void run(IPerspectiveDescriptor desc) {
        IPreferenceStore store = PlatformUI.getWorkbench().getPreferenceStore();
        int mode = store.getInt(IPreferenceConstants.OPEN_PERSP_MODE);
        IWorkbenchPage page = window.getActivePage();
        IPerspectiveDescriptor persp = null;
        if (page != null)
            persp = page.getPerspective();

        // Only open a new window if user preference is set and the window
        // has an active perspective.
        if (IPreferenceConstants.OPM_NEW_WINDOW == mode && persp != null) {
            try {
                IWorkbench workbench = window.getWorkbench();
                IAdaptable input = ((Workbench) workbench)
                        .getDefaultPageInput();
                workbench.openWorkbenchWindow(desc.getId(), input);
            } catch (WorkbenchException e) {
                handleWorkbenchException(e);
            }
        } else {
            if (page != null) {
                page.setPerspective(desc);
            } else {
                try {
                    IWorkbench workbench = window.getWorkbench();
                    IAdaptable input = ((Workbench) workbench)
                            .getDefaultPageInput();
                    window.openPage(desc.getId(), input);
                } catch (WorkbenchException e) {
                    handleWorkbenchException(e);
                }
            }
        }
    }

    /**
     * Handles workbench exception
     */
    private void handleWorkbenchException(WorkbenchException e) {
        ErrorDialog.openError(window.getShell(), WorkbenchMessages.ChangeToPerspectiveMenu_errorTitle, e
                .getMessage(), e.getStatus());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}