/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.dialog;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.util.Messages;

/**
 * ƥȥꥢ˥ƥȤɽ뤿ΥǤ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class TextAreaDialog extends CommonDialog {

    // ----- instance ե ----- //
	
	/** ѹβ/Բ */
    private boolean m_modify = false;
	
    /** ƥȥꥢ */
    private Text m_text = null;
    
    /** Υȥ */
    private String m_title = Messages.getString("text");
    
    /** ƥȥꥢɽʸ */
    private String m_displayString = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * Υ󥹥󥹤֤ޤ
     * 
     * @param parent ƤȤ륷
     */
    public TextAreaDialog(Shell parent) {
        super(parent);
        setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
    }
    
    /**
     * Υ󥹥󥹤֤ޤ
     * 
     * @param parent ƤȤ륷
     * @param title Υȥ
     * @param modify ѹβ/Բĥե饰
     */
    public TextAreaDialog(Shell parent, String title, boolean modify) {
        super(parent);
        setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
        if(title != null){
        	this.m_title = title;
        }
        this.m_modify = modify;
    }

    // ----- instance ᥽å ----- //

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    protected void customizeDialog(Composite parent) {
        // ȥ
        parent.getShell().setText(m_title);

        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        
        // ƥȥꥢ
        this.m_text = new Text(parent, SWT.MULTI | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_text.setLayoutData(gridData);
        
        this.m_text.setText(m_displayString);
       	this.m_text.setEditable(this.m_modify);
    }
    
    /**
     * ƥ
     * 
     * @param displayString
     */
    public void setText(String displayString) {
    	this.m_displayString = displayString;
    }

    /**
     * ƥȼ
     * 
     * @return
     */
    public String getText() {
        return this.m_displayString;
    }

    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
    
    /* ( Javadoc)
	 * @see com.clustercontrol.dialog.CommonDialog#validate()
	 */
	protected ValidateResult validate() {
		this.m_displayString = this.m_text.getText();
		return null;
	}

	/**
     * ܥޤ
     * 
     * @param parent ܥСݥå
     */
    protected void createButtonsForButtonBar(Composite parent) {
    	
        if(this.m_modify){
        	super.createButtonsForButtonBar(parent);
        }
        else{
        	// Ĥܥ
            this.createButton(parent, IDialogConstants.CANCEL_ID, Messages.getString("ok"), false);
        }
    }
}