/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.dialog;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.util.Messages;

/**
 * ץĥ꡼饹פ⤷ϥΡɤ򤹤뤿ΥǤ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeTreeDialog extends CommonDialog {

    // ----- instance ե ----- //

    /** 򤵤줿ƥ */
    protected FacilityTreeComposite treeComposite = null;

    protected boolean scopeOnly;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * Υ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤȤ륷
     */
    public ScopeTreeDialog(Shell parent) {
        super(parent);
        this.scopeOnly = false;
    }

    /**
     * Υ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤȤ륷
     * @param scopeOnly
     */
    public ScopeTreeDialog(Shell parent, boolean scopeOnly) {
        super(parent);
        this.scopeOnly = scopeOnly;
    }

    // ----- instance ᥽å ----- //

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    protected void customizeDialog(Composite parent) {
        // ȥ
        parent.getShell().setText(Messages.getString("select.scope"));

        GridLayout layout = new GridLayout(5, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        treeComposite = new FacilityTreeComposite(parent, SWT.NONE, scopeOnly);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        treeComposite.setLayoutData(gridData);

        // ƥ֥륯å硢򤷤ȤȤ롣
        treeComposite.getTreeViewer().addDoubleClickListener(
                new IDoubleClickListener() {
                    public void doubleClick(DoubleClickEvent event) {
                        okPressed();
                    }
                });
    }

    public FacilityTreeItem getSelectItem() {
        return this.treeComposite.getSelectItem();
    }

    protected ValidateResult validate() {
        ValidateResult result = null;

        FacilityTreeItem item = this.getSelectItem();
        if (item instanceof FacilityTreeItem) {
            if (item.getData().getType() == FacilityConstant.TYPE_COMPOSITE) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.hinemos.3"));
            }
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.hinemos.3"));
        }

        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
}