/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

/**
 * ŪѤǤ饹Ǥ
 * <p>
 * 
 * ŪˤϡgetInitialSizecustomizeDialogƲ <br>
 * ͥå»ܤ硢validateƲ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CommonDialog extends Dialog {

    // ----- 󥹥ȥ饯 ----- //

    /**
     * parentϢʤΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            Shell֥
     */
    public CommonDialog(Shell parent) {
        super(parent);
    }

    // ----- instance ᥽å ----- //

    /**
     * ΥޥԤޤ
     * <p>
     * 
     * @param composite
     *            ꥢΥݥåȥ֥
     */
    protected void customizeDialog(Composite composite) {
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return null;
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return null;
    }

    /**
     * ͥåԤޤ
     * <p>
     * 
     * ɬפ˱ơͥåƲ
     * 
     * @return ValidateResult֥
     */
    protected ValidateResult validate() {
        return null;
    }

    /**
     * ϣ˥ܥ󤬲줿˸ƤФ᥽åɤǡͥå»ܤޤ
     * <p>
     * 
     * 顼ξ硢Ĥ˥顼ƤΤޤ
     */
    protected void okPressed() {
        ValidateResult result = this.validate();

        if (result == null || result.isValid()) {
            super.okPressed();
        } else {
            this.displayError(result);
        }
    }

    /**
     * 顼ƤΤޤ
     * <p>
     * 
     * ٹåܥåˤơ饤ȤΤޤ
     * 
     * @param result
     *            ValidateResult֥
     */
    protected void displayError(ValidateResult result) {
        MessageBox messageBox = new MessageBox(this.getShell(), SWT.OK
                | SWT.ICON_WARNING);

        messageBox.setText(result.getID());
        messageBox.setMessage(result.getMessage());

        messageBox.open();
    }

    // ----- Dialog饹ΥС饤ɥ᥽å ----- //

    protected Control createContents(Composite parent) {
        Composite composite = (Composite) super.createContents(parent);

        // ꥢΥޥ
        this.customizeDialog((Composite) this.getDialogArea());

        // ϣ˥ܥΥƥѹ
        String okText = this.getOkButtonText();
        if (okText != null) {
            Button button = this.getButton(IDialogConstants.OK_ID);
            if (button != null) {
                button.setText(okText);
            }
        }

        // 󥻥ܥΥƥѹ
        String cancelText = this.getCancelButtonText();
        if (cancelText != null) {
            Button button = this.getButton(IDialogConstants.CANCEL_ID);
            if (button != null) {
                button.setText(cancelText);
            }
        }

        return composite;
    }
}