/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import java.io.Serializable;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefine;

/**
 * ƥȥꥢץѥƥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class TextAreaPropertyDefine extends PropertyDefine implements Serializable {

	private static final long serialVersionUID = -5855792499351692500L;
	
	/** ƥȥꥢ ȥ */
	protected String m_title = null;
    
    /** ץѥƥѹβ/Բ */
    protected boolean m_modify = false;

	/**
     * 󥹥ȥ饯
     * 
     * @since 2.0.0
     */
    public TextAreaPropertyDefine() {
        m_cellEditor = new TextAreaDialogCellEditor();
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getColumnText(java.lang.Object)
     */
    public String getColumnText(Object value) {
        if (value instanceof String) {
            return (String) value;
        } else {
            return "";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getValue(com.clustercontrol.bean.Property)
     */
    public Object getValue(Property element) {
        Object value = element.getValue();
        if (value instanceof String) {
            return (String) value;
        } else {
            return "";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#modify(com.clustercontrol.bean.Property,
     *      java.lang.Object)
     */
    public void modify(Property element, Object value) {
        if (value instanceof String) {
            element.setValue(value);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#initEditer()
     */
    public void initEditer() {
        ((TextAreaDialogCellEditor)m_cellEditor).setTitle(m_title);
        ((TextAreaDialogCellEditor)m_cellEditor).setModify(m_modify);
    }
    
    /**
     * ȥ
     * 
     * @param title Υȥ
     */
    public void setTitle(String title) {
    	m_title = title;
    }

    /**
     * ȥ
     * 
     * @return m_title
     */
    public String getTitle() {
        return m_title;
    }
    
    /**
     * ץѥƥѹβ/Բ
     * 
     * @param title ץѥƥѹβ/Բ
     */
    public void setModify(boolean modify) {
    	m_modify = modify;
    }

    /**
     * ץѥƥѹβ/Բļ
     * 
     * @return m_modify
     */
    public boolean getmodify() {
        return m_modify;
    }
}