/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;

/**
 * ץѥƥȥ饹ѤModifier饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class PropertySheetModifier implements ICellModifier {
    private PropertySheet m_viewer;

    /**
     * 󥹥ȥ饯
     * 
     * @param viewer
     */
    public PropertySheetModifier(PropertySheet viewer) {
        this.m_viewer = viewer;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ICellModifier#canModify(java.lang.Object,
     *      java.lang.String)
     */
    public boolean canModify(Object element, String property) {
        if (property == PropertySheet.CLMN_VALUE) {
            if (element instanceof Property) {

                Property nodeProperty = (Property) element;

                if (nodeProperty.getModify() == PropertyConstant.MODIFY_OK) {
                    // ǥǥΤФơǥڤؤ롣
                    CellEditor cellEditor = nodeProperty.getCellEditor();
                    
                    if (cellEditor.getControl() == null || cellEditor.getControl().isDisposed()) {
                    	cellEditor.dispose();
                        cellEditor.create(m_viewer.getTableTree().getTable());
                        nodeProperty.initEditer();
                    }

                    CellEditor[] editors = new CellEditor[] { null, cellEditor };
                    m_viewer.setCellEditors(editors);

                    return true;
                }
                else{
                	if(nodeProperty.getEditor().compareTo(
                            PropertyConstant.EDITOR_TEXTAREA) == 0){
                		// ǥǥΤФơǥڤؤ롣
                        CellEditor cellEditor = nodeProperty.getCellEditor();

                        if (cellEditor.getControl() == null || cellEditor.getControl().isDisposed()) {
                        	cellEditor.dispose();
                        	cellEditor.create(m_viewer.getTableTree().getTable());
                            nodeProperty.initEditer();
                        }

                        CellEditor[] editors = new CellEditor[] { null, cellEditor };
                        m_viewer.setCellEditors(editors);
                        
                        return true;
                	}
                }
            }
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ICellModifier#getValue(java.lang.Object,
     *      java.lang.String)
     */
    public Object getValue(Object element, String property) {
        if (property == PropertySheet.CLMN_VALUE) {
            //ΤͤФ
            if (element instanceof Property) {
                Property nodeProperty = (Property) element;
                return nodeProperty.getModifyValue();
            }
        }
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ICellModifier#modify(java.lang.Object,
     *      java.lang.String, java.lang.Object)
     */
    public void modify(Object element, String property, Object value) {
        if (property == PropertySheet.CLMN_VALUE) {

            //Τ͹ѥ᥽åɤƤӽФ
            if (element instanceof Item) {
                element = ((Item) element).getData();

                if (element instanceof Property) {

                    //ͤιѥ᥽åɤƤӽФ
                    Property nodeProperty = (Property) element;
                    nodeProperty.modify(value);
                    m_viewer.expandToLevel(nodeProperty, 1);

                    // ӥ塼򹹿
                    m_viewer.refresh();
                }
            }
        }
    }
}