/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.PropertyDefine;
import com.clustercontrol.composite.action.CopyPropertyAction;
import com.clustercontrol.composite.action.DeletePropertyAction;
import com.clustercontrol.util.Messages;

/**
 * ץѥƥȥ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class PropertySheet extends TableTreeViewer {
    public static final String CLMN_KEY = "key";

    public static final String CLMN_VALUE = "value";

    private TableColumn keyColumn;

    private TableColumn valueColumn;

    private boolean copy = false;

    /**
     * @return Returns the copy.
     */
    public boolean isCopy() {
        return copy;
    }

    /**
     * @param copy
     *            The copy to set.
     */
    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    /**
     * 󥹥ȥ饯
     * 
     * @param tree
     *            ơ֥ĥ꡼
     * @since 1.0.0
     */
    public PropertySheet(TableTree tree) {
        super(tree);

        Table table = tree.getTable();

        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        // ơ֥륫
        keyColumn = new TableColumn(table, SWT.NONE);
        keyColumn.setText(Messages.getString("name"));
        keyColumn.setWidth(200);
        valueColumn = new TableColumn(table, SWT.NONE);
        valueColumn.setText(Messages.getString("value"));
        valueColumn.setWidth(200);

        setContentProvider(new PropertySheetContentProvider());
        setLabelProvider(new PropertySheetLabelProvider());
        setColumnProperties(new String[] { CLMN_KEY, CLMN_VALUE, });

        // ƥꤹ륻롦ǥ
        CellEditor[] editors = new CellEditor[] { null, new TextCellEditor() };

        //롦ǥ
        setCellEditors(editors);

        //롦ǥե
        setCellModifier(new PropertySheetModifier(this));

        //ݥåץåץ˥塼
        createContextMenu();
    }

    /**
     * ݥåץåץ˥塼
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //˥塼
                if (isCopy()) {
                    fillContextMenu(manager);
                }
            }
        });

        Menu menu = menuManager.createContextMenu(this.getTableTree());
        this.getTableTree().setMenu(menu);
    }

    /**
     * ˥塼ɲ
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ݥåץåץ˥塼˥ɲ
        manager.add(new CopyPropertyAction(this));
        manager.add(new DeletePropertyAction(this));
    }

    public void setInput(Property property) {
        //Property
        Object[] childrens = property.getChildren();

        //PropertyPropertyDefine
        for (int i = 0; i < childrens.length; i++) {
            Property children = (Property) childrens[i];
            setPropertyDefine(children);
        }

        super.setInput(property);
    }

    public void setPropertyDefine(Property property) {

        //PropertyDefine
        if (property.getDefine() == null) {
            PropertyDefine define = null;
            try {
                define = (PropertyDefine) Class.forName(property.getEditor())
                        .newInstance();
                if (property.getEditor().compareTo(
                        PropertyConstant.EDITOR_SELECT) == 0) {
                    ((ComboPropertyDefine) define).setValues(property
                            .getSelectValues());
                }
                else if(property.getEditor().compareTo(
                        PropertyConstant.EDITOR_TEXTAREA) == 0){
                	((TextAreaPropertyDefine) define).setTitle(property.getName());
                	if(property.getModify() == PropertyConstant.MODIFY_OK){
                		((TextAreaPropertyDefine) define).setModify(true);
                	}
                }
            } catch (InstantiationException e) {
            } catch (IllegalAccessException e) {
            } catch (ClassNotFoundException e) {
            }
            property.setDefine(define);
        }

        if (property.getEditor().compareTo(PropertyConstant.EDITOR_SELECT) == 0) {
            Object[][] value = property.getSelectValues();

            for (int j = 0; j < value[PropertyConstant.SELECT_VALUE].length; j++) {
                if (value[PropertyConstant.SELECT_VALUE][j] instanceof HashMap) {
                    HashMap map = (HashMap) value[PropertyConstant.SELECT_VALUE][j];

                    ArrayList propertyList = (ArrayList) map
                            .get(PropertyConstant.MAP_PROPERTY);
                    if (propertyList instanceof ArrayList) {
                        for (int k = 0; k < propertyList.size(); k++) {
                            Property children = (Property) propertyList.get(k);
                            setPropertyDefine(children);
                        }
                    }
                }
            }
        }

        //Property
        Object[] childrens = property.getChildren();

        //PropertyPropertyDefine
        for (int i = 0; i < childrens.length; i++) {
            Property children1 = (Property) childrens[i];
            setPropertyDefine(children1);
        }
    }
}