/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.ui.ClusterControlUIPlugin;

/**
 * ץĥ꡼ѤΥ٥ץХ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityTreeLabelProvider extends LabelProvider {

    public String getText(Object element) {
        FacilityInfo info = ((FacilityTreeItem) element).getData();

        int type = info.getType();
        if (type == FacilityConstant.TYPE_COMPOSITE) {
            return info.getFacilityName();
        } else {
            return info.getFacilityName() + " (" + info.getFacilityId() + ")";
        }
    }

    public Image getImage(Object element) {
        ImageRegistry registry = ClusterControlUIPlugin.getDefault()
                .getImageRegistry();

        switch (((FacilityTreeItem) element).getData().getType()) {
        case FacilityConstant.TYPE_COMPOSITE:
            return registry.getDescriptor(ClusterControlUIPlugin.IMG_CONSOLE)
                    .createImage();
        case FacilityConstant.TYPE_SCOPE:
            return registry.getDescriptor(ClusterControlUIPlugin.IMG_SCOPE)
                    .createImage();
        case FacilityConstant.TYPE_NODE:
            return registry.getDescriptor(ClusterControlUIPlugin.IMG_NODE)
                    .createImage();
        default:
            return null;
        }
    }
}