/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

import com.clustercontrol.action.GetFacilityTree;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.etc.action.UpdateFacilityTreeTask;
import com.clustercontrol.util.UpdateRepositoryInfoReceiveTopic;

/**
 * ץĥ꡼ɽ륳ݥåȥ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityTreeComposite extends Composite {

    //	 ----- instance ե ----- //

    /** ĥ꡼ӥ塼 */
    protected TreeViewer treeViewer = null;

    /** 򥢥ƥ */
    protected FacilityTreeItem selectItem = null;

    /** 򥢥ƥ */
    protected int subScopeNumber;

    /** 򥢥ƥ */
    protected boolean scopeOnly;
    
    protected UpdateRepositoryInfoReceiveTopic updateRepository = null;

    // ----- 󥹥ȥ饯 ----- //

    public FacilityTreeComposite(Composite parent, int style) {
        super(parent, style);

        this.scopeOnly = false;

        this.createContents();
    }

    public FacilityTreeComposite(Composite parent, int style, boolean scopeOnly) {
        super(parent, style);

        this.scopeOnly = scopeOnly;

        this.createContents();
    }

    // ----- instance ᥽å ----- //

    /**
     * ΥݥåȤѤĥ꡼ӥ塼֤ޤ
     * 
     * @return ĥ꡼ӥ塼
     */
    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    /**
     * ΥݥåȤѤĥ꡼֤ޤ
     * 
     * @return ĥ꡼
     */
    public Tree getTree() {
        return this.treeViewer.getTree();
    }

    /**
     * 򤵤Ƥĥ꡼ƥ֤ޤ
     * 
     * @return ĥ꡼ƥ
     */
    public FacilityTreeItem getSelectItem() {
        return this.selectItem;
    }

    /**
     * 򤵤Ƥĥ꡼Υ֥׿֤ޤ
     * 
     * @return ֥׿
     */
    public int getSubScopeNumber() {
        return subScopeNumber;
    }

    /**
     * ݥåȤޤ
     */
    protected void createContents() {

        // ݥåȤΥ쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout(layout);

        // ĥ꡼
        Tree tree = new Tree(this, SWT.SINGLE | SWT.BORDER);

        // ĥ꡼Υ쥤ȥǡ
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = GridData.FILL;
        layoutData.verticalAlignment = GridData.FILL;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        tree.setLayoutData(layoutData);

        // ĥ꡼ӥ塼
        this.treeViewer = new TreeViewer(tree);

        // ĥ꡼ӥ塼
        this.treeViewer.setContentProvider(new FacilityTreeContentProvider());
        this.treeViewer.setLabelProvider(new FacilityTreeLabelProvider());
        this.treeViewer.setSorter(new FacilityTreeViewerSorter());

        // 򥢥ƥ٥
        this.treeViewer
                .addSelectionChangedListener(new ISelectionChangedListener() {
                    public void selectionChanged(SelectionChangedEvent event) {
                        StructuredSelection selection = (StructuredSelection) event
                                .getSelection();

                        selectItem = (FacilityTreeItem) selection
                                .getFirstElement();

                        if (selectItem instanceof FacilityTreeItem) {
                            subScopeNumber = selectItem.getChildren().length;
                        }
                    }
                });
        
        //ޥ͡㤫Υեƥĥ꡼
        this.updateRepository = new UpdateRepositoryInfoReceiveTopic(this.getDisplay(), new UpdateFacilityTreeTask(this));

        this.addDisposeListener(new DisposeListener(){
			public void widgetDisposed(DisposeEvent e) {
				if(updateRepository != null){
					updateRepository.terminate();
				}
			}
        });
        
        // ɽޤ
        this.update();
    }

    /**
     * ӥ塼ɽƤ򹹿ޤ
     */
    public void update() {
        GetFacilityTree getFacilityTree = new GetFacilityTree();
        FacilityTreeItem treeItem = getFacilityTree.getTreeItem(scopeOnly);

        if(treeItem != null){
        	this.treeViewer.setInput(treeItem);
        	FacilityTreeItem selectItem[] = treeItem.getChildren();
        	this.treeViewer.setSelection(new StructuredSelection(selectItem[0]), true);
        }
        
        //פΥ٥ޤŸ
        this.treeViewer.expandToLevel(2);
    }

    /**
     * ĥ꡼Ÿɽ뤫ꤷޤ
     *  
     */
    public void setExpand(boolean isExpand) {
        if (isExpand) {
            this.treeViewer.setAutoExpandLevel(TreeViewer.ALL_LEVELS);
        }
    }

    /**
     * ĥ꡼ɽƤ򹹿ޤ
     * 
     * @param treeItem
     */
    public void setScopeTree(FacilityTreeItem treeItem) {
        try {
            this.treeViewer.setInput(treeItem);
            this.treeViewer.setAutoExpandLevel(TreeViewer.ALL_LEVELS);

        } catch (Exception e) {
        }
    }

    /**
     * Tree򥻥åȤʤfacilityIDбǤ֤ˤޤ
     * 
     * @param treeItem
     * @param facilityID
     */
    public void setScopeTreeWithSelection(FacilityTreeItem treeItem,
            String facilityID) {
        this.setScopeTree(treeItem);

        FacilityTreeItem[] tmpItem = treeItem.getChildren();

        //FaiclityIDбTreeItem뤫õޤ
        for (int i = 0; i < tmpItem.length; i++) {
            setScopeTreeWithSelectionSub(tmpItem[i], facilityID);
            if (facilityID.equals(tmpItem[i].getData().getFacilityId())) {
                this.treeViewer.setSelection(
                        new StructuredSelection(tmpItem[i]), true);
            }
        }
    }

    /**
     * setScopeTreeWithSelectionƤФ뤳ȤƵѤΥ᥽å
     * 
     * @param treeItem
     * @param facilityID
     */
    public void setScopeTreeWithSelectionSub(FacilityTreeItem treeItem,
            String facilityID) {
        FacilityTreeItem[] tmpItem = treeItem.getChildren();

        for (int i = 0; i < tmpItem.length; i++) {
            setScopeTreeWithSelectionSub(tmpItem[i], facilityID);

            if (facilityID.equals(tmpItem[i].getData().getFacilityId())) {
                this.treeViewer.setSelection(
                        new StructuredSelection(tmpItem[i]), true);

            }
        }

    }
}