/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import java.util.ArrayList;
import java.util.Date;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

/**
 * CommonTableViewer饹ѤViewerSorter饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CommonTableViewerSorter extends ViewerSorter {
    /** ।ǥå */
    protected int m_columnIndex = 0;

    /** ȥ */
    protected int m_order = 1;

    /**
     * 󥹥ȥ饯
     * 
     * @param column
     *            оݥ।ǥå
     * @since 1.0.0
     */
    public CommonTableViewerSorter(int columnIndex) {
        this(columnIndex, 1);
    }

    /**
     * 󥹥ȥ饯
     * 
     * @param column
     *            оݥ।ǥå
     * @param order
     *            ȥ
     * @since 1.0.0
     */
    public CommonTableViewerSorter(int columnIndex, int order) {
        super();

        this.m_columnIndex = columnIndex;
        this.m_order = order;
    }

    /**
     * ӽ
     * 
     * @param viewer
     * @param e1
     * @param e2
     * @return ӷ̡super饹η̤򥽡ȥˤȿž
     * @since 1.0.0
     */
    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof ArrayList && e2 instanceof ArrayList) {
            Object object1 = ((ArrayList) e1).get(m_columnIndex);
            Object object2 = ((ArrayList) e2).get(m_columnIndex);

            int rtn = 0;
            if (object1 != null && object2 != null
                    && object1.getClass() == Date.class
                    && object2.getClass() == Date.class) {
                rtn = ((Date) object1).compareTo((Date) object2);
            } else {
                rtn = super.compare(viewer, object1, object2);
            }

            if (m_order == 1) {
                return rtn;
            } else {
                return 0 - rtn;
            }
        }
        return 0;
    }

    /**
     * оݥ।ǥå
     * 
     * @return ।ǥå
     * @since 1.0.0
     */
    public int getColumnIndex() {
        return this.m_columnIndex;
    }
}