/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import java.util.ArrayList;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

import com.clustercontrol.bean.TableColumnInfo;

/**
 * ̥ơ֥ӥ塼饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CommonTableViewer extends TableViewer {
    protected ArrayList m_tableColumnList = null;

    protected boolean m_sortType = true;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @since 1.0.0
     */
    public CommonTableViewer(Composite parent) {
        super(parent);
        setLabelProvider(new CommonTableLabelProvider(this));
        setContentProvider(new CommonTableContentProvider());
    }

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     * @since 1.0.0
     */
    public CommonTableViewer(Composite parent, int style) {
        super(parent, style);
        setLabelProvider(new CommonTableLabelProvider(this));
        setContentProvider(new CommonTableContentProvider());
    }

    /**
     * 󥹥ȥ饯
     * 
     * @param table
     * @since 1.0.0
     */
    public CommonTableViewer(Table table) {
        super(table);
        setLabelProvider(new CommonTableLabelProvider(this));
        setContentProvider(new CommonTableContentProvider());
    }

    /**
     * ơ֥륫κ
     * 
     * @param tableColumnList
     * @since 1.0.0
     */
    public void createTableColumn(ArrayList tableColumnList,
            int sortColumnIndex, int sortOrder) {
        this.m_tableColumnList = tableColumnList;

        for (int i = 0; i < this.m_tableColumnList.size(); i++) {
            TableColumnInfo tableColumnInfo = (TableColumnInfo) this.m_tableColumnList
                    .get(i);
            TableColumn column = new TableColumn(getTable(), tableColumnInfo
                    .getStyle(), i);
            column.setText(tableColumnInfo.getName());
            column.setWidth(tableColumnInfo.getWidth());

            //ɽΥ
            if (i == sortColumnIndex) {
                int order = sortOrder;
                tableColumnInfo.setOrder(order);
                setSorter(new CommonTableViewerSorter(i, order));
            }

            //Ѥ˥Υꥹʡ
            column.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    TableColumn column = (TableColumn) e.getSource();

                    ArrayList tableColumnList = getTableColumnList();
                    for (int i = 0; i < tableColumnList.size(); i++) {
                        TableColumnInfo tableColumnInfo = (TableColumnInfo) tableColumnList
                                .get(i);
                        if (tableColumnInfo.getName().compareTo(
                                column.getText()) == 0) {
                            int order = tableColumnInfo.getOrder() * -1;
                            tableColumnInfo.setOrder(order);
                            setSorter(new CommonTableViewerSorter(i, order));
                            break;
                        }
                    }
                }
            });
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.StructuredViewer#doUpdateItem(org.eclipse.swt.widgets.Widget,
     *      java.lang.Object, boolean)
     */
    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof TableItem) {
            final TableItem item = (TableItem) widget;

            // remember element we are showing
            if (fullMap) {
                associate(element, item);
            } else {
                item.setData(element);
                mapElement(element, item);
            }

            IBaseLabelProvider prov = getLabelProvider();
            ICommonTableLabelProvider tprov = null;

            if (prov instanceof ICommonTableLabelProvider) {
                tprov = (ICommonTableLabelProvider) prov;

                int columnCount = super.getTable().getColumnCount();
                TableItem ti = item;
                // Also enter loop if no columns added. See 1G9WWGZ: JFUIF:WINNT
                // - TableViewer with 0 columns does not work
                for (int column = 0; column < columnCount || column == 0; column++) {
                    // Similar code in TableTreeViewer.doUpdateItem()
                    String text = "";//$NON-NLS-1$
                    Image image = null;
                    Color color = null;
                    if (tprov != null) {
                        text = tprov.getColumnText(element, column);
                        image = tprov.getColumnImage(element, column);
                        color = tprov.getColumnColor(element, column);
                    }
                    ti.setText(column, text);
                    if (ti.getImage(column) != image) {
                        ti.setImage(column, image);
                    }
                    if (color != null) {
                        ti.setBackground(column, color);
                    }
                }
                if (prov instanceof IColorProvider) {
                    IColorProvider cprov = (IColorProvider) prov;
                    ti.setForeground(cprov.getForeground(element));
                    ti.setBackground(cprov.getBackground(element));
                }
                if (prov instanceof IFontProvider) {
                    IFontProvider fprov = (IFontProvider) prov;
                    ti.setFont(fprov.getFont(element));
                }
            } else {
                //ICommonTableLabelProviderƤʤ硢ѡ饹ƤӽФ
                super.doUpdateItem(widget, element, fullMap);
            }
        }
    }

    /**
     * ơ֥륫
     * 
     * @return ơ֥륫
     * @since 1.0.0
     */
    public ArrayList getTableColumnList() {
        return this.m_tableColumnList;
    }

    /**
     * ơ֥륫।ǥå
     * 
     * @param type
     * @return
     * @since 1.0.0
     */
    public int getTableColumnIndex(int type) {
        int index = -1;

        for (int i = 0; i < m_tableColumnList.size(); i++) {
            TableColumnInfo tableColumn = (TableColumnInfo) m_tableColumnList
                    .get(i);

            if (type == tableColumn.getType()) {
                index = i;
                break;
            }
        }

        return index;
    }
}