/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import java.io.Serializable;

import org.eclipse.jface.viewers.CheckboxCellEditor;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefine;

/**
 * åܥåץѥƥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class BooleanPropertyDefine extends PropertyDefine implements
        Serializable {

    /**
     * 󥹥ȥ饯
     * 
     * @since 1.0.0
     */
    public BooleanPropertyDefine() {
        m_cellEditor = new CheckboxCellEditor();
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getColumnText(java.lang.Object)
     */
    public String getColumnText(Object value) {
        //ͤɽƥ
        if (value instanceof Boolean) {
            if (((Boolean) value).booleanValue()) {
                return "";
            } else {
                return "";
            }
        }
        return "";
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getValue(com.clustercontrol.bean.Property)
     */
    public Object getValue(Property element) {
        //CheckboxϤͤBooleanѴ
        Object value = element.getValue();
        if (value instanceof Boolean) {
            return value;
        } else {
            return new Boolean(false);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#modify(com.clustercontrol.bean.Property,
     *      java.lang.Object)
     */
    public void modify(Property element, Object value) {
        //BooleanͤѴ
        if (value instanceof Boolean) {
            element.setValue(value);
        } else {
            element.setValue(new Boolean(false));
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#initEditer()
     */
    public void initEditer() {

    }
}