/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.calendar.composite.WeekdayInfoListComposite;
import com.clustercontrol.calendar.view.action.WeekdayInfoAddAction;
import com.clustercontrol.calendar.view.action.WeekdayInfoDeleteAction;
import com.clustercontrol.calendar.view.action.WeekdayInfoModifyAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * ̾ӥ塼饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class WeekdayInfoListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.calendar.view.WeekdayInfoListView";

    private WeekdayInfoListComposite m_weekdayList = null;

    /**
     * 󥹥ȥ饯
     */
    public WeekdayInfoListView() {
        super();
    }

    /**
     * ViewPartؤΥȥ
     * 
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_weekdayList = new WeekdayInfoListComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        m_weekdayList.setLayoutData(gridData);

        //ݥåץåץ˥塼
        createContextMenu();

        //ӥ塼򹹿
        this.update(null);
    }

    /**
     * ݥåץåץ˥塼
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //˥塼
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(m_weekdayList.getTable());
        m_weekdayList.getTable().setMenu(menu);
    }

    /**
     * ˥塼ɲ
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ӥ塼ΥΥ󥹥󥹤
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
    	ActionContributionItem add = 
    		(ActionContributionItem) toolbar.find(WeekdayInfoAddAction.ID);
    	ActionContributionItem modify = 
    		(ActionContributionItem) toolbar.find(WeekdayInfoModifyAction.ID);
    	ActionContributionItem delete = 
    		(ActionContributionItem) toolbar.find(WeekdayInfoDeleteAction.ID);
    	
    	//ݥåץåץ˥塼˥ɲ
    	manager.add(add.getAction());
    	manager.add(modify.getAction());
    	manager.add(delete.getAction());
    }

    /**
     * ̰ӥ塼
     */
    public void update(String calendarId) {
    	m_weekdayList.update(calendarId);
    }

    /**
     * ݥåȼ
     * 
     * @return
     */
    public WeekdayInfoListComposite getComposite() {
        return m_weekdayList;
    }
}