/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.dialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.calendar.action.AddCalendarProperty;
import com.clustercontrol.calendar.action.GetCalendarProperty;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * κѹ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CalendarDialog extends CommonDialog {
    /** ID */
    private String id = "";

    /** ѹѥȽ̥ե饰 */
    private int mode;

    /** ץѥƥ */
    private PropertySheet propertySheet = null;
    /**
     * ꤷΥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     * @param id
     *            ID
     * @param mode
     *            ɽ⡼
     */
    public CalendarDialog(Shell parent, String uid, int mode) {
        super(parent);

        this.id = uid;
        this.mode = mode;
    }
    
    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(500, 600);
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages
                .getString("dialog.calendar.calendar.create.modify"));

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        /*
         * °ץѥƥ
         */

        // ٥
        Label label = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("attribute") + " : ");

        // ץѥƥ
        TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI | SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);

        // ץѥƥڤ
        Property property = null;
        if (this.mode == PropertyConstant.MODE_MODIFY) {
            property = new GetCalendarProperty().getProperty(this.id,
                    PropertyConstant.MODE_MODIFY);
        } 
        else if (this.mode == PropertyConstant.MODE_ADD) {
            property = new GetCalendarProperty().getProperty(this.id,
                    PropertyConstant.MODE_ADD);
        }
        else if (this.mode == PropertyConstant.MODE_SHOW) {
            property = new GetCalendarProperty().getProperty(this.id,
                    PropertyConstant.MODE_SHOW);
        }
        this.propertySheet.setInput(property);
        this.propertySheet.expandAll();

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {

        return super.validate();
    }

    /**
     * ͤݻǡǥޤ
     * 
     * @return ǡǥ
     */
    public Property getInputData() {
        return (Property) this.propertySheet.getInput();
    }

    /**
     * ͤݻǡǥꤷޤ
     * 
     * @param property
     */
    public void setInputData(Property property) {
        propertySheet.setInput(property);
    }

    /**
     * @return Returns the uid.
     */
    public String getUid() {
        return this.id;
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        if (this.mode == PropertyConstant.MODE_MODIFY) {
            return Messages.getString("modify");
        }
        else if (this.mode == PropertyConstant.MODE_ADD) {
            return Messages.getString("register");
        }
        else{
            return Messages.getString("ok");
        }
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

	@Override
	protected void okPressed() {
        ValidateResult result = this.validate();

        if (result == null || result.isValid()) {
        	//
        	if(this.mode == PropertyConstant.MODE_ADD) {
        		Property addProperty = PropertyUtil.copy(getInputData());
                PropertyUtil.deletePropertyDefine(addProperty);
                if (new AddCalendarProperty().add(addProperty)) {
                    // 
                    MessageBox box = new MessageBox(this.getShell(), SWT.ICON_INFORMATION);
                    box.setText(Messages.getString("successful"));
                    box.setMessage(Messages.getString("message.calendar.1"));
                    box.open();
                } else {
                    // 
                    MessageBox box = new MessageBox(this.getShell(), SWT.ICON_ERROR);
                    box.setText(Messages.getString("failed"));
                    box.setMessage(Messages.getString("message.calendar.2"));
                    box.open();
                }
        	}
        	else{
        		super.okPressed();
        	}
        } else {
            this.displayError(result);
        }
	}
}