/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.calendar.bean.CalendarListTableDefine;
import com.clustercontrol.calendar.composite.CalendarListComposite;
import com.clustercontrol.calendar.view.AddInfoListView;
import com.clustercontrol.calendar.view.WeekdayInfoListView;

/**
 * ơ֥SelectionChangedListener饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CalendarSelectionChangedListener implements ISelectionChangedListener {
    protected CalendarListComposite m_composite;

    /**
     * 󥹥ȥ饯
     * 
     * @param composite
     * @since 1.0.0
     */
    public CalendarSelectionChangedListener(CalendarListComposite composite) {
        m_composite = composite;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
        String calenadarId = null;
        
        //ID
        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
            ArrayList info = (ArrayList) ((StructuredSelection) event
                    .getSelection()).getFirstElement();
            calenadarId = (String) info.get(CalendarListTableDefine.CALENDAR_ID);
            //ID
            m_composite.setCalendarId(calenadarId);
        }

        //ƥ֥ڡ
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        //ӥ塼򹹿
        IViewPart viewPart = page.findView(WeekdayInfoListView.ID);
        if (viewPart != null) {
        	WeekdayInfoListView view = (WeekdayInfoListView) viewPart
                    .getAdapter(WeekdayInfoListView.class);
            view.update(calenadarId);
        }
        
        //ӥ塼򹹿
        viewPart = page.findView(AddInfoListView.ID);
        if (viewPart != null) {
        	AddInfoListView view = (AddInfoListView) viewPart
                    .getAdapter(AddInfoListView.class);
            view.update(calenadarId);
        }
    }
}

