/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.dialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;

/**
 * ѥѹ饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyPasswordDialog extends CommonDialog {
    protected Text m_uidText = null;
    protected Text m_passwordText1 = null;
    protected Text m_passwordText2 = null;
    protected String m_uid = null;
    protected String m_password = null;

    protected Shell m_shell = null;

    public ModifyPasswordDialog(Shell parent) {
        super(parent);
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        m_shell = this.getShell();
        
        m_shell.setText(Messages
                .getString("dialog.accesscontrol.modify.user.password"));

        RowLayout layout = new RowLayout();
        layout.type = SWT.VERTICAL;
        layout.spacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        parent.setLayout(layout);

        Composite composite = null;
        RowLayout rowLayout = null;

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label uidTitle = new Label(composite, SWT.NONE);
        uidTitle.setText(Messages.getString("user.id") + " : ");
        uidTitle.setLayoutData(new RowData(150, SizeConstant.SIZE_LABEL_HEIGHT));
        m_uidText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
        m_uidText.setLayoutData(new RowData(150, SizeConstant.SIZE_TEXT_HEIGHT));
        m_uidText.setText(m_uid);
        
        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label passwordTitle1 = new Label(composite, SWT.NONE);
        passwordTitle1.setText(Messages.getString("password") + " : ");
        passwordTitle1.setLayoutData(new RowData(150, SizeConstant.SIZE_LABEL_HEIGHT));
        m_passwordText1 = new Text(composite, SWT.BORDER | SWT.PASSWORD);
        m_passwordText1.setLayoutData(new RowData(150, SizeConstant.SIZE_TEXT_HEIGHT));

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label passwordTitle2 = new Label(composite, SWT.NONE);
        passwordTitle2.setText(Messages.getString("confirm.password") + " : ");
        passwordTitle2.setLayoutData(new RowData(150, SizeConstant.SIZE_LABEL_HEIGHT));
        m_passwordText2 = new Text(composite, SWT.BORDER | SWT.PASSWORD);
        m_passwordText2.setLayoutData(new RowData(150, SizeConstant.SIZE_TEXT_HEIGHT));

        new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);

        // 
        Display display = m_shell.getDisplay();
        m_shell.setLocation(
                (display.getBounds().width - m_shell.getSize().x) / 2, (display
                        .getBounds().height - m_shell.getSize().y) / 2);

    }

    /**
     * ͥåԤޤ
     * 
     * ɬפ˱ơͥåƲ
     * 
     * @return ValidateResult֥
     */
    protected ValidateResult validate() {
        ValidateResult result = null;

        //ѥɼ
        if (m_passwordText1.getText().length() > 0) {
        	setPassword(m_passwordText1.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.accesscontrol.2"));
            return result;
        }
        
        //ѥɼ
        if (m_passwordText2.getText().length() > 0) {
        	setPassword(m_passwordText2.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.accesscontrol.3"));
            return result;
        }
        
        //ѥɳǧ
        if (m_passwordText1.getText().compareTo(m_passwordText2.getText()) != 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.accesscontrol.4"));
            return result;
        }
        
        //ѥɼ
        m_password = m_passwordText1.getText();

        return null;
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
    
	public String getPassword() {
		return m_password;
	}

	public void setPassword(String password) {
		m_password = password;
	}

	public String getUserid() {
		return m_uid;
	}

	public void setUserid(String uid) {
		m_uid = uid;
	}
}