/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.util;

import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingContextFactory;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.repository.bean.TopicConstant;
import com.clustercontrol.repository.message.UpdateRepositoryInfo;

/**
 * Topic饹
 * Topicؤ³ȡåμԤ
 * @version 2.0.0
 * @since 2.0.0
 * 
 */
public class UpdateRepositoryInfoReceiveTopic implements MessageListener, ExceptionListener {
	private static final String TOPIC_CON_FACTORY = "ConnectionFactory";
	private static final String KEY_EJB_URL = "ejbUrl";
    private static final String VALUE_EJB_URL = "jnp://localhost:1099";
	private static final long RETRY_INTERVAL = 10000;
	
	private TopicConnectionFactory m_factory;
	protected TopicConnection m_con;
	protected Topic m_topic;
	protected TopicSession m_session;
	protected TopicSubscriber m_subscriber;
	
	protected Runnable m_repositoryUpdate;
	protected Display m_display;
	
	private boolean m_errFlg = false;
	
	/** åӥ³ѥޡ * */
	protected Timer m_timer = new Timer(true);
	
	/**
	 * 󥹥ȥ饯
	 * @param facilityIdList եƥIDΥꥹȡ
	 * @param sendQueueåѥ饹
	 * @param propsץѥƥե
	 */
	@SuppressWarnings("unchecked")
	public UpdateRepositoryInfoReceiveTopic(Display display, Runnable repositoryUpdate) {
		super();
		 
		m_display = display;
		m_repositoryUpdate = repositoryUpdate;
		 
		//³
		initial();
	}
	
	/* 
	 * ȥԥå
	 * (non-Javadoc)
	 * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
	 */
	public void onMessage(Message message) {
		
		if(message instanceof ObjectMessage){
			ObjectMessage objectMessage = (ObjectMessage)message;
			Object obj;
			try {
				obj = objectMessage.getObject();
			} catch (JMSException e) {
				return;
			}
			
			if(obj instanceof UpdateRepositoryInfo){
				
				UpdateRepositoryInfo info = (UpdateRepositoryInfo)obj;
				
			
				m_display.syncExec(m_repositoryUpdate);

				
			}else{
				return;
			}
		}else{
			return;
		}
	}
	
	/* ̿顼ϥɥ
	 * (non-Javadoc)
	 * @see javax.jms.ExceptionListener#onException(javax.jms.JMSException)
	 */
	public void onException(JMSException arg0) {
		setErrFlg(true);
	}
	
	/**
	 * @param errFlg
	 *            errFlg ꡣ
	 */
	synchronized private void setErrFlg(boolean errFlg) {
		if (m_errFlg == false && errFlg == true) {
			
			m_timer.schedule(new ReSetupTask(), RETRY_INTERVAL,
					RETRY_INTERVAL);
			
		}
		m_errFlg = errFlg;
	}
	
	/**
	 * @return errFlg ᤷޤ
	 */
	synchronized private boolean isErrFlg() {
		return m_errFlg;
	}
	/**
	 *  
	 */
	synchronized private boolean reInitial() {
		boolean ret = false;
		
		terminate();
		
		if (initial()) {
			
			ret = true;
			
			//顼ե饰
			setErrFlg(false);
			
		} else {
			
		}
		
		return ret;
	}
	/**
	 * ³νλ
	 *  
	 */
	public void terminate() {
		
		terminateSumscriber();
		
		
		try {
			if (m_session != null)
				m_session.close();
		} catch (JMSException e) {
		}
		
		try {
			if (m_con != null)
				m_con.close();
		} catch (JMSException e1) {
		}
	}
	/**
	 * ȥԥåνλ 
	 */
	private void terminateSumscriber() {
		try {
			if (m_subscriber != null)
				m_subscriber.close();
		} catch (JMSException e) {
		}
	}
	
	
	
	/**
	 * 
	 * JMSؤ³ȥԥåԤ
	 * @return
	 */
	private boolean initial() {
		
		NamingContext con = null;
		
		try {
			String url = getUrl();
			
	        Hashtable props = new Hashtable();
	        props.put(InitialContext.PROVIDER_URL, url);
	        
	        NamingContextFactory ncf = new NamingContextFactory();
	        con = (NamingContext)ncf.getInitialContext(props);
			
			//ͥեȥ
			m_factory = (TopicConnectionFactory)con.lookup(TOPIC_CON_FACTORY);
			
			//ͥ
			m_con = m_factory.createTopicConnection();
			
			//å
			m_session = m_con.createTopicSession(false,
					Session.AUTO_ACKNOWLEDGE);
			
			//åTopic
			m_topic = (Topic)con.lookup(TopicConstant.TOPIC_NAME_EXECUTE);
			
			
			//顼ϥɤ饻å
			m_con.setExceptionListener(this);
			
			m_con.start();
			
			//ȥԥå³
			initialTopic();
			
			
		} catch (Exception e) {
			setErrFlg(true);
			return false;
		} finally {
			try {
				if (con != null)
					con.close();
			} catch (Exception e1) {
			}
		}
		return true;
		
	}
	
    /**
     * ³URLޤ
     * 
     * @return String ³URL
  	 * @version 2.0.0
	 * @since 2.0.0
     */
    private String getUrl() {

        //꥽ȥ³URL
        IPreferenceStore store = ClusterControlPlugin.getDefault()
                .getPreferenceStore();
        String url = store.getString(KEY_EJB_URL);
        if (url.compareTo("") == 0) {
            url = VALUE_EJB_URL;
        }

        return url;
    }
	
	/**
	 * ȥԥå
	 * @return
	 * @since
	 */
	private boolean initialTopic() {
		
		
		//ߤTopicλ
		terminateSumscriber();
		
		//եƥIDǥȥԥå
		try {
			m_subscriber = m_session.createSubscriber(m_topic);
			
			//ХåϿ
			m_subscriber.setMessageListener(this);

		} catch (Exception e) {
			setErrFlg(true);
			return false;
		} finally {
		}
		return true;
		
	}
	/**
	 * EJB³ޡ
	 * ̿顼ȤʤäǸƤФ³Ԥ 
	 */
	protected class ReSetupTask extends TimerTask {
		
		/**
		 * ͥ󥯥
		 */
		public void run() {
			if (reInitial()) {
				//Υ򥿥ޡ
				cancel();
			}
		}
		
	}
	
}
