/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;

import com.clustercontrol.bean.OutputFormConstant;

/**
 * ĢɼϤ륯饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ReportGenerator {
	
	/** jasperѥ */
	protected String m_jasperPath;
	
	/** Ϸ */
	protected int m_outputForm;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param path jasperѥ
	 */
	public ReportGenerator(String path, int form) {
		m_jasperPath = path;
		m_outputForm = form;
	}
	
	/**
	 * Ģɼ
	 * 
	 * @param destPath Ģɼϥѥ
	 * @param paramMap ѥ᡼
	 * @param collectionData ǡ
	 * @return ĢɼϤ硢true
	 */
	public boolean run(String destPath, Map paramMap, Collection collectionData) {
		Thread cur = Thread.currentThread();
		ClassLoader save = cur.getContextClassLoader();
		
		try {
			cur.setContextClassLoader(JasperCompileManager.class.getClassLoader());
			
			JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(collectionData);
			JasperPrint print = JasperFillManager.fillReport(m_jasperPath, paramMap, ds);
			
			if(m_outputForm == OutputFormConstant.TYPE_PDF){
				// PDFؽ
				JasperExportManager.exportReportToPdfFile(print, destPath);
			}
			else if(m_outputForm == OutputFormConstant.TYPE_CSV){
				// CSVؽ
				JRCsvExporter exporter = new JRCsvExporter();
				exporter.setParameter(JRExporterParameter.JASPER_PRINT, print);
				exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, destPath);
				exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, System.getProperty("file.encoding"));
				
				exporter.exportReport();
			}
			return true;
			
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		finally{
			cur.setContextClassLoader(save);
		}
	}
}