/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.util.StatusLineContributionItem;
import org.jboss.naming.NamingContextFactory;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.accesscontrol.dialog.LoginDialog;
import com.clustercontrol.accesscontrol.ejb.session.AccessCheck;
import com.clustercontrol.accesscontrol.ejb.session.AccessCheckHome;

/**
 * ޥ͡㥯饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class LoginManager {
    public static final String KEY_EJB_URL = "ejbUrl";
    public static final String VALUE_EJB_URL = "jnp://localhost:1099";
    
    public static final String USER_OBJECT_ID = "com.clustercontrol.accesscontrol.user";
    
    public static final String ACTION_SET_ID    = "com.clustercontrol.accesscontrol.ActionSet";
    public static final String ACTION_ID_LOGIN  = "com.clustercontrol.accesscontrol.etc.action.LoginAction";
    public static final String ACTION_ID_LOGOUT = "com.clustercontrol.accesscontrol.etc.action.LogoutAction";
    
    private static LoginManager m_instance = null;
    private NamingContext m_namingcontext = null;
    private LoginContext m_loginContext = null;
    private String m_url = null;
    private String m_uid = null;
    private String m_password = null;

    /**
     * Υ֥Ȥޤ 󥰥ȥ
     * 
     * @return LoginManager ޥ͡
     * 
	 * @version 2.0.0
	 * @since 2.0.0
     */
    public static LoginManager getContextManager() {
        if (m_instance == null) {
            m_instance = new LoginManager();
        }
        return m_instance;
    }

    /**
     * 󥹥ȥ饯
     * 
   	 * @version 2.0.0
	 * @since 2.0.0
     */
    private LoginManager() {
        try {
           Configuration.setConfiguration(new HinemosClientConfig());
        } catch(Exception e) {
        }
    }
    
    /**
     * 
     * 
     * @param uid
     * @param password
     * @throws NamingException
     * @throws LoginException
     * 
	 * @version 2.0.0
	 * @since 2.0.0
     */
    public synchronized void login(String uid, String password) throws Exception {
    	//
    	logout();
    	
    	m_uid = uid;
    	m_password = password;
    	
    	//NamingContext
    	m_namingcontext = getContext();
    	
    	try {
        	//å
        	AccessCheckHome home = (AccessCheckHome)m_namingcontext.lookup(AccessCheckHome.JNDI_NAME);
        	
			AccessCheck accessCheck = home.create();
			
			accessCheck.checkLogin();
			
			// ơСإ桼IDϿ
			IWorkbench workbench = PlatformUI.getWorkbench();
			WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
			IActionBars bars = workbenchWindow.getActionBars();
			IStatusLineManager lineManager = bars.getStatusLineManager();
			
			StatusLineContributionItem statusLine = new StatusLineContributionItem(USER_OBJECT_ID);
			statusLine.setText(Messages.getString("hinemos.user") + " : " + m_uid);
			lineManager.add(statusLine);
			lineManager.update(true);
			
		} catch (Exception e) {
			logout();
			throw e;
		}
    }
    
    /**
     * 
     * 
     * @throws NamingException
     * 
	 * @version 2.0.0
	 * @since 2.0.0
     */
    public synchronized void logout() throws NamingException {
    	if(m_loginContext instanceof LoginContext){
    		try {
				m_loginContext.logout();
				
				m_uid = null;
				
				// ơС桼ID
				IWorkbench workbench = PlatformUI.getWorkbench();
				WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
				IActionBars bars = workbenchWindow.getActionBars();
				
				IStatusLineManager lineManager = bars.getStatusLineManager();
				IContributionItem item = lineManager.find(USER_OBJECT_ID);
				lineManager.remove(item);
				lineManager.update(true);
				
			} catch (LoginException e) {
			}
    	}
		m_loginContext = null;
		m_namingcontext = null;
    }
    
    /**
     * å
     * 
     * @return
     * 
	 * @version 2.0.0
	 * @since 2.0.0
     */
    public boolean isLogin() {
    	if(m_loginContext instanceof LoginContext){
    		return true;
    	}
    	else{
    		return false;
    	}
    }
    
    /**
     * RepositoryCollectorޤ
     * 
     * @return RepositoryCollector
     * 
     * @version 2.0.0
	 * @since 2.0.0
     */
    public synchronized NamingContext getNamingContext() throws NamingException {
    	if(!isLogin()){
    		
			Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
			
    		//ɽ
            LoginDialog dialog = new LoginDialog(shell);
            
            //ɽ
            if (dialog.open() == IDialogConstants.OK_ID) {
            	try {
    				login(dialog.getUserid(), dialog.getPassword());
    	
    	            // 
    	            MessageBox box = new MessageBox(shell, SWT.ICON_INFORMATION);
    	            box.setText(Messages.getString("successful"));
    	            box.setMessage(Messages.getString("message.accesscontrol.5"));
    	            box.open();
    			} catch (Exception e) {
                    // ԥ
                    MessageBox box = new MessageBox(shell, SWT.ICON_ERROR);
                    box.setText(Messages.getString("failed"));
                    box.setMessage(Messages.getString("message.accesscontrol.6"));
                    box.open();
    			}
            }
    	}
    	return m_namingcontext;
    }

    /**
     * NamingContextޤ
     * 
     * @return
     * @throws NamingException
     * @throws LoginException
     * 
 	 * @version 2.0.0
	 * @since 2.0.0
     */
    @SuppressWarnings("unchecked")
	private NamingContext getContext() throws NamingException, LoginException {
        //³URL
        m_url = getUrl();

        Hashtable props = new Hashtable();
        props.put(InitialContext.PROVIDER_URL, m_url);
        
    	UsernamePasswordHandler handler = new UsernamePasswordHandler(m_uid, m_password.toCharArray());
		m_loginContext = new LoginContext("hinemosClient", handler);
		m_loginContext.login();
		
        NamingContextFactory ncf = new NamingContextFactory();
        NamingContext namingContext = (NamingContext) ncf
                .getInitialContext(props);
        
        return namingContext;
    }
    
    /**
     * ³URLޤ
     * 
     * @return String ³URL
  	 * @version 2.0.0
	 * @since 2.0.0
     */
    private String getUrl() {

        //꥽ȥ³URL
        IPreferenceStore store = ClusterControlPlugin.getDefault()
                .getPreferenceStore();
        String url = store.getString(KEY_EJB_URL);
        if (url.compareTo("") == 0) {
            url = VALUE_EJB_URL;
        }

        return url;
    }
    
    /**
	 * HinemosClientѤΥե졼󥯥饹
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
     */
    class HinemosClientConfig extends Configuration
    {
    	/* (non-Javadoc)
    	 * @see javax.security.auth.login.Configuration#refresh()
    	 */
    	public void refresh() {
    		
    	}
    	
    	/* (non-Javadoc)
    	 * @see javax.security.auth.login.Configuration#getAppConfigurationEntry(java.lang.String)
    	 */
    	public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
    		AppConfigurationEntry[] entry = null;
    		try {
    			Class[] parameterTypes = {};
    			Method m = getClass().getDeclaredMethod(name, parameterTypes);
    			Object[] args = {};
    			entry = (AppConfigurationEntry[]) m.invoke(this, args);
    		} catch(Exception e) {
    		}
    		return entry;
    	}
    	
    	/**
    	 * Hinemos Client Configuration
    	 * @return
    	 */
    	@SuppressWarnings("unchecked")
    	AppConfigurationEntry[] hinemosClient() {
    		String name = "org.jboss.security.ClientLoginModule";
    		HashMap options = new HashMap();
    		options.put("multi-threaded", "true");
    		options.put("restore-login-identity", "true");
    		AppConfigurationEntry ace = new AppConfigurationEntry(name,
    				AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
    		AppConfigurationEntry[] entry = {ace};
    		return entry;
    	}
    }
}