/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.preference;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.util.Messages;

/**
 * ִǽڡ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ClusterControlCorePreferencePage extends FieldEditorPreferencePage
        implements IWorkbenchPreferencePage {

    /** EJB³URL */
    public static final String EJB_URL = LoginManager.KEY_EJB_URL;

    /**
     * ͤꤵ줿󥹥󥹤֤ޤ
     */
    public ClusterControlCorePreferencePage() {
        super(GRID);
        this.setPreferenceStore(ClusterControlPlugin.getDefault()
                .getPreferenceStore());

        this.initializeDefaults();
    }

    /**
     * ͤꤷޤ
     */
    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();

        store.setDefault(EJB_URL, LoginManager.VALUE_EJB_URL);
    }

    /**
     * եɤޤ
     */
    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridData gridData = null;
        // []ӥ塼Ϣ
        Group group = new Group(parent, SWT.SHADOW_NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        group.setLayoutData(gridData);

        group.setText(Messages.getString("jboss.connection.setting"));

        // ³URL
        this.addField(new StringFieldEditor(EJB_URL, Messages
                .getString("connection.url"), group));
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.preference.IPreferencePage#performOk()
     */
    public boolean performOk() {
        boolean result = super.performOk();

        //å³URLǼ
        IPreferenceStore store = this.getPreferenceStore();
        store.getString(EJB_URL);

        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
     */
    public void init(IWorkbench workbench) {

    }
}