/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.calendar.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ɲþѹ饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyAddInfoProperty {

    /**
     * ꤷɲþˤĤơ°ѹԤޤ
     * 
     * @param property °
     * @return ѹ硢true
     */
    public boolean edit(String id, Date from, Date to, Property property) {
		CalendarController calendar = 
			EjbConnectionManager.getConnectionManager().getCalendarController();
		
        try {
        	calendar.modifyAddInfo(id, from, to, property);
            return true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NamingException e) {
        } catch (FinderException e) {
        } catch (RemoveException e) {
		} catch (CreateException e) {
		}
        return false;
    }
}