/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.ClusterControlPlugin;

/**
 * 顼ϥ饹
 * 
 * 顼ӥ塼˥顼Ϥ롣
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ErrorLog {

    /**
     * 顼Ͽ
     * 
     * 顼å򥨥顼˵Ͽ
     * 
     * @param message
     *            ϥå
     * @param e
     *            Exception饹
     */
    public static void log(String message, Exception e) {
        ClusterControlPlugin plugin = ClusterControlPlugin.getDefault();

        IStatus status = new Status(IStatus.ERROR, plugin.getBundle()
                .getSymbolicName(), 0, message, e);

        plugin.getLog().log(status);
    }

    /**
     * 顼ɽ
     * 
     * 顼å򥨥顼ɽ
     * 
     * @param message
     *            ϥå
     * @param e
     *            Exception饹
     */
    public static void openErrorDialog(String message, Exception e) {
        ClusterControlPlugin plugin = ClusterControlPlugin.getDefault();

        IStatus status = new Status(IStatus.ERROR, plugin.getBundle()
                .getSymbolicName(), 0, message, e);

        //顼ɽ
        ErrorDialog.openError(PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getShell(), "Error", null, status);
    }
}