/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import com.clustercontrol.util.Messages;

/**
 * 饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class StatusConstant {
    /** Ե(֤μ) */
    public static final int TYPE_WAIT = 0;

    /** α(֤μ) */
    public static final int TYPE_RESERVING = 1;

    /** å(֤μ) */
    public static final int TYPE_SKIP = 2;

    /** ¹(֤μ) */
    public static final int TYPE_RUNNING = 100;

    /** ߽(֤μ) */
    public static final int TYPE_STOPPING = 101;

    /** (֤μ) */
    public static final int TYPE_SUSPEND = 200;

    /** ¨(֤μ) */
    public static final int TYPE_STOP = 201;

    /** λ(֤μ) */
    public static final int TYPE_END = 300;

    /** ѹ(֤μ) */
    public static final int TYPE_MODIFIED = 301;

    /** ư(֤μ) */
    public static final int TYPE_ERROR = 400;

    /** Ե(֤μ) */
    public static final String STRING_WAIT = Messages.getString("wait");

    /** α(֤μ) */
    public static final String STRING_RESERVING = Messages
            .getString("reserving");

    /** å(֤μ) */
    public static final String STRING_SKIP = Messages.getString("skip");

    /** ¹(֤μ) */
    public static final String STRING_RUNNING = Messages.getString("running");

    /** ߽(֤μ) */
    public static final String STRING_STOPPING = Messages.getString("stopping");

    /** (֤μ) */
    public static final String STRING_SUSPEND = Messages.getString("suspend");

    /** ¨(֤μ) */
    public static final String STRING_STOP = Messages.getString("stop.at.once");

    /** λ(֤μ) */
    public static final String STRING_END = Messages.getString("end");

    /** ѹ(֤μ) */
    public static final String STRING_MODIFIED = Messages.getString("modified");

    /** ư(֤μ) */
    public static final String STRING_ERROR = Messages.getString("start.error");

    /**
     * ̤ʸѴ
     * 
     * @param type
     * @return
     */
    public static String typeToString(int type) {
        if (type == TYPE_RUNNING) {
            return STRING_RUNNING;
        } else if (type == TYPE_END) {
            return STRING_END;
        } else if (type == TYPE_WAIT) {
            return STRING_WAIT;
        } else if (type == TYPE_STOPPING) {
            return STRING_STOPPING;
        } else if (type == TYPE_STOP) {
            return STRING_STOP;
        } else if (type == TYPE_RESERVING) {
            return STRING_RESERVING;
        } else if (type == TYPE_MODIFIED) {
            return STRING_MODIFIED;
        } else if (type == TYPE_ERROR) {
            return STRING_ERROR;
        } else if (type == TYPE_SKIP) {
            return STRING_SKIP;
        } else if (type == TYPE_SUSPEND) {
            return STRING_SUSPEND;
        }
        return "";
    }

    /**
     * ʸ󤫤̤Ѵ
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_RUNNING)) {
            return TYPE_RUNNING;
        } else if (string.equals(STRING_END)) {
            return TYPE_END;
        } else if (string.equals(STRING_WAIT)) {
            return TYPE_WAIT;
        } else if (string.equals(STRING_STOPPING)) {
            return TYPE_STOPPING;
        } else if (string.equals(STRING_STOP)) {
            return TYPE_STOP;
        } else if (string.equals(STRING_RESERVING)) {
            return TYPE_RESERVING;
        } else if (string.equals(STRING_MODIFIED)) {
            return TYPE_MODIFIED;
        } else if (string.equals(STRING_ERROR)) {
            return TYPE_ERROR;
        } else if (string.equals(STRING_SKIP)) {
            return TYPE_SKIP;
        } else if (string.equals(STRING_SUSPEND)) {
            return TYPE_SUSPEND;
        }
        return -1;
    }
}