/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.io.Serializable;

import org.eclipse.jface.viewers.CellEditor;

/**
 * ץѥƥ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class Property extends PropertyTreeItem implements Serializable {
    /** ץѥƥ */
    protected Object m_Value;

    /** ץѥƥ */
    protected String m_Editor;

    /** ץѥƥ */
    protected PropertyDefine m_Define;

    /** ץѥƥѹβ/Բ */
    protected int m_Modify;

    /** ץѥƥΥԡ/Բ */
    protected int m_Copy;

    /** ץѥƥѹ */
    protected Object m_selectValues[][];

    /**
     * @param id
     * @param name
     * @param define
     * @since 1.0.0
     */
    public Property(String id, String name, String editor) {
        m_ID = id;
        m_Name = name;
        m_Editor = editor;
        m_Define = null;
        m_Copy = PropertyConstant.COPY_NG;
        m_Modify = PropertyConstant.MODIFY_NG;
    }

    /**
     * ץѥƥѹβ/Բļ
     * 
     * @return canModify
     * @since 1.0.0
     */
    public int getModify() {
        return m_Modify;
    }

    /**
     * ץѥƥѹβ/Բ
     * 
     * @param modify
     * @since 1.0.0
     */
    public void setModify(int modify) {
        m_Modify = modify;
    }

    /**
     * ץѥƥͼ
     * 
     * @return ץѥƥ
     * @since 1.0.0
     */
    public Object getValue() {
        return m_Value;
    }

    /**
     * ץѥƥ
     * 
     * @param value
     *            ץѥƥ
     * @since 1.0.0
     */
    public void setValue(Object value) {
        m_Value = value;
    }

    /**
     * ץѥƥ
     * 
     * @return ץѥƥ
     * @since 1.0.0
     */
    public PropertyDefine getDefine() {
        return m_Define;
    }

    /**
     * ץѥƥ
     * 
     * @param define
     *            ץѥƥ
     * @since 1.0.0
     */
    public void setDefine(PropertyDefine define) {
        m_Define = define;
    }

    /**
     * @return Returns the m_selectValues.
     */
    public Object[][] getSelectValues() {
        return m_selectValues;
    }

    /**
     * @param values
     *            The m_selectValues to set.
     */
    public void setSelectValues(Object[][] values) {
        m_selectValues = values;
    }

    /**
     * @return Returns the m_Copy.
     */
    public int getCopy() {
        return m_Copy;
    }

    /**
     * @param copy
     *            The m_Copy to set.
     */
    public void setCopy(int copy) {
        m_Copy = copy;
    }

    /**
     * @return Returns the m_Editor.
     */
    public String getEditor() {
        return m_Editor;
    }

    /**
     * @param editor
     *            The m_Editor to set.
     */
    public void setEditor(String editor) {
        m_Editor = editor;
    }

    /**
     * ץѥƥʸ
     * 
     * @return ץѥƥʸ
     * @since 1.0.0
     */
    public String getValueText() {
        return m_Define.getColumnText(m_Value);
    }

    /**
     * CellEditor
     * 
     * @return CellEditor
     * @since 1.0.0
     */
    public CellEditor getCellEditor() {
        return m_Define.getCellEditor();
    }

    /**
     * CellEditor
     * 
     * @since 1.0.0
     */
    public void initEditer() {
        m_Define.initEditer();
    }

    /**
     * @return
     * @since 1.0.0
     */
    public Object getModifyValue() {
        return m_Define.getValue(this);
    }

    /**
     * @param value
     * @since 1.0.0
     */
    public void modify(Object value) {
        m_Define.modify(this, value);
    }
}