/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import com.clustercontrol.util.Messages;

/**
 * 饹
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class PriorityConstant {
    /** (٤μ) */
    public static final int TYPE_CRITICAL = 0;

    /** ٹ(٤μ) */
    public static final int TYPE_WARNING = 2;

    /** (٤μ) */
    public static final int TYPE_INFO = 3;

    /** (٤μ) */
    public static final int TYPE_UNKNOWN = 1;

    /** ʤ(٤μ) */
    public static final int TYPE_NONE = 4;

    /** (٤μ) */
    public static final String STRING_CRITICAL = Messages.getString("critical");

    /** ٹ(٤μ) */
    public static final String STRING_WARNING = Messages.getString("warning");

    /** (٤μ) */
    public static final String STRING_INFO = Messages.getString("info");

    /** (٤μ) */
    public static final String STRING_UNKNOWN = Messages.getString("unknown");

    /** ʤ(٤μ) */
    public static final String STRING_NONE = "";

    /**
     * ̤ʸѴ
     * 
     * @param type
     * @return
     */
    public static String typeToString(int type) {
        if (type == TYPE_CRITICAL) {
            return STRING_CRITICAL;
        } else if (type == TYPE_WARNING) {
            return STRING_WARNING;
        } else if (type == TYPE_INFO) {
            return STRING_INFO;
        } else if (type == TYPE_UNKNOWN) {
            return STRING_UNKNOWN;
        } else if (type == TYPE_NONE) {
            return STRING_NONE;
        }
        return "";
    }

    /**
     * ʸ󤫤̤Ѵ
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_CRITICAL)) {
            return TYPE_CRITICAL;
        } else if (string.equals(STRING_WARNING)) {
            return TYPE_WARNING;
        } else if (string.equals(STRING_INFO)) {
            return TYPE_INFO;
        } else if (string.equals(STRING_UNKNOWN)) {
            return TYPE_UNKNOWN;
        } else if (string.equals(STRING_NONE)) {
            return TYPE_NONE;
        }
        return -1;
    }
}