/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * ׾ĥ꡼¤뤿Υ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityTreeItem implements Serializable {

    //	 ----- static ե ----- //

    /** ѥѥ졼 */
    public static final String SEPARATOR = ">";

    //	 ----- instance ե ----- //

    /**  */
    private FacilityTreeItem parent = null;

    /** 󥪥֥ */
    private FacilityInfo data = null;

    /** ҤγǼꥹ */
    private List childrens = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * ξݻ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ֥
     * @param data
     *            ׾󥪥֥
     */
    public FacilityTreeItem(FacilityTreeItem parent, FacilityInfo data) {

        this.setParent(parent);
        this.setData(data);

        if (parent != null) {
            parent.addChildren(this);
        }

        this.childrens = new ArrayList();
    }

    // ----- instance ե ----- //

    /**
     * Ƥ֤ޤ
     * 
     * @return 
     */
    public FacilityTreeItem getParent() {
        return this.parent;
    }

    /**
     * Ƥꤷޤ
     * <p>
     * 
     * 󥹥󥹲κݤ˿ƤشطդƤ뤿ᡢҤ᥽åɤ ˲Ļ()礷Ʋ <br>
     * ޤƤؤδطդԤ褦˼Ʋ
     * 
     * @return 
     */
    public void setParent(FacilityTreeItem parent) {
        this.parent = parent;
    }

    /**
     * ׾֤ޤ
     * 
     * @return ׾
     */
    public FacilityInfo getData() {
        return this.data;
    }

    /**
     * ׾ꤷޤ
     * 
     * @param data
     *            ׾
     */
    public void setData(FacilityInfo data) {
        this.data = data;
    }

    /**
     * Ҥɲäޤ
     * <p>
     * 
     * κݡchildeοƤϤΥ֥ȤȤꤵޤ
     * 
     * @param child
     *            
     */
    public void addChildren(FacilityTreeItem child) {
        child.setParent(this);
        childrens.add(child);
    }

    /**
     * Ҥο֤ޤ
     * 
     * @return Ҥο
     */
    public int size() {
        return childrens.size();
    }

    /**
     * ƤλҤ֤ޤ
     * <p>
     * 
     * ¤ӽϡɲä줿ȤʤäƤޤ
     * 
     * @return Ƥλҡ
     */
    public FacilityTreeItem[] getChildren() {
        FacilityTreeItem[] result = new FacilityTreeItem[this.size()];
        return (FacilityTreeItem[]) childrens.toArray(result);
    }
}