/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

/**
 * 
 * ActionBarAdvisor饹Ѿ륯饹
 * RCPActionBarʤɤԤ饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ClusterControlActionBarAdvisor extends ActionBarAdvisor {
	private IWorkbenchAction helpContentsAction;
	private IWorkbenchAction aboutAction;

	public ClusterControlActionBarAdvisor(IActionBarConfigurer configurer) {
		super(configurer);
	}

	protected void makeActions(final IWorkbenchWindow window) {
		//إץƥĥ(org.eclipse.ui.internal.actions.HelpContentsAction)
		helpContentsAction = ActionFactory.HELP_CONTENTS.create(window);
		register(helpContentsAction);
		
		//ʾ󥢥(org.eclipse.ui.internal.about.AboutAction)
        aboutAction = ActionFactory.ABOUT.create(window);
        register(aboutAction);
	}

	protected void fillMenuBar(IMenuManager menuBar) {
		//إץ˥塼ɲ
		MenuManager helpMenu = new MenuManager(JFaceResources.getString("help"),
				IWorkbenchActionConstants.M_HELP);
		//ʾѥإץ˥塼ɲ
		MenuManager aboutMenu = new MenuManager(JFaceResources.getString("help"),
				IWorkbenchActionConstants.M_HELP + "_about");
		
		menuBar.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		menuBar.add(helpMenu);
		menuBar.add(aboutMenu);
		
		//إץƥĥɲ
		helpMenu.add(helpContentsAction);
		
		//ʾ󥢥ɲ
		aboutMenu.add(aboutAction);
		
		//إץ˥塼ɽȤ롣ʸѤʤ
		helpMenu.setVisible(false);
	}
}
