/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.factory;

import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.calendar.ejb.entity.CalendarInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarInfoUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ѥץѥƥ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class CalendarProperty {
	/** ID */
	public static final String ID = "id";
	/** ̾ */
	public static final String NAME = "name";
	/** ͭ */
	public static final String VALID_TIME_FROM = "validTimeFrom";
	/** ͭ */
	public static final String VALID_TIME_TO = "validTimeTo";
	/**  */
	public static final String DESCRIPTION = "description";
	/**  */
	public static final String CREATE_TIME = "createTimestamp";
	/**  */
	public static final String CREATOR_NAME = "creatorName";
	/**  */
	public static final String MODIFIER_NAME = "ModifierName";
	/**  */
	public static final String MODIFY_TIME = "ModifyTime";
	
	/**
	 * ѥץѥƥ֤ޤ
	 * 
	 * @param id
	 * @param mode
	 * @param local
	 * @return ѥץѥƥ
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getProperty(String id, int mode, Locale local) throws FinderException, NamingException {
		Property property = getProperty(mode, local);
		
		if(id != null && id.compareTo("") != 0){
		    //
			CalendarInfoLocal info = CalendarInfoUtil.getLocalHome().findByPrimaryKey(id);
			
			if(info != null){
				//id
				ArrayList propertyList = PropertyUtil.getProperty(property, ID);
				((Property)propertyList.get(0)).setValue(info.getCalendar_id());
				//̾
				propertyList = PropertyUtil.getProperty(property, NAME);
				if(info.getCalendar_name() != null && info.getCalendar_name().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getCalendar_name());
				}
				//ͭ(From)
				propertyList = PropertyUtil.getProperty(property, VALID_TIME_FROM);
				if(info.getValid_time_from() != null){
					((Property)propertyList.get(0)).setValue(info.getValid_time_from());
				}
				//ͭ(To)
				propertyList = PropertyUtil.getProperty(property, VALID_TIME_TO);
				if(info.getValid_time_to() != null){
					((Property)propertyList.get(0)).setValue(info.getValid_time_to());
				}
				//
				propertyList = PropertyUtil.getProperty(property, DESCRIPTION);
				if(info.getDescription() != null && info.getDescription().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getDescription());
				}
				//Ͽ
				propertyList = PropertyUtil.getProperty(property, CREATOR_NAME);
				if(info.getReg_user() != null && info.getReg_user().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getReg_user());
				}
				//Ͽ
				propertyList = PropertyUtil.getProperty(property, CREATE_TIME);
				if(info.getReg_date() != null){
					((Property)propertyList.get(0)).setValue(info.getReg_date());
				}
				//
				propertyList = PropertyUtil.getProperty(property, MODIFIER_NAME);
				if(info.getUpdate_user() != null && info.getUpdate_user().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getUpdate_user());
				}
				//
				propertyList = PropertyUtil.getProperty(property, MODIFY_TIME);
				if(info.getUpdate_date() != null){
					((Property)propertyList.get(0)).setValue(info.getUpdate_date());
				}
			}
		}
		
		return property;
	}
	
	/**
	 * ѥץѥƥ֤ޤ
	 * 
	 * @param mode
	 * @return ѥץѥƥ
	 */
	public Property getProperty(int mode, Locale locale) {
	    //ID
		Property id =
			new Property(ID, Messages.getString("calendar.id", locale), PropertyConstant.EDITOR_TEXT);
		//̾
		Property name =
			new Property(NAME, Messages.getString("name", locale), PropertyConstant.EDITOR_TEXT);
		//ͭ(From)
		Property validTimeFrom =
			new Property(VALID_TIME_FROM, Messages.getString("valid.time", locale) + "(" + Messages.getString("start", locale) + ")", 
					PropertyConstant.EDITOR_DATETIME);
		//ͭ(To)
		Property validTimeTo =
			new Property(VALID_TIME_TO, Messages.getString("valid.time", locale) + "(" + Messages.getString("end", locale) + ")"
					, PropertyConstant.EDITOR_DATETIME);
		//
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT);
		//Ͽ
		Property createTime =
			new Property(CREATE_TIME, Messages.getString("create.time", locale), PropertyConstant.EDITOR_DATETIME);
		//Ͽ
		Property creatorName =
			new Property(CREATOR_NAME, Messages.getString("creator.name", locale), PropertyConstant.EDITOR_TEXT);
		//
		Property modifyTime =
			new Property(MODIFY_TIME, Messages.getString("update.time", locale), PropertyConstant.EDITOR_DATETIME);
		//
		Property modifierName =
			new Property(MODIFIER_NAME, Messages.getString("modifier.name", locale), PropertyConstant.EDITOR_TEXT);

		//ͤ
		id.setValue("");
		name.setValue("");
		validTimeFrom.setValue("");
		validTimeTo.setValue("");
		description.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");

		//⡼ɤˤꡢѹĵڤӥԡĤ
		if(mode == PropertyConstant.MODE_ADD){
			id.setModify(PropertyConstant.MODIFY_OK);
			name.setModify(PropertyConstant.MODIFY_OK);
			validTimeFrom.setModify(PropertyConstant.MODIFY_OK);
			validTimeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			name.setModify(PropertyConstant.MODIFY_OK);
			validTimeFrom.setModify(PropertyConstant.MODIFY_OK);
			validTimeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		// ɽĥ꡼
		property.removeChildren();
		property.addChildren(id);
		property.addChildren(name);
		property.addChildren(validTimeFrom);
		property.addChildren(validTimeTo);
		property.addChildren(description);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);

		return property;
	}
}
