/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.agent;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.agent.util.RunHistoryUtil;
import com.clustercontrol.jobmanagement.bean.CommandConstant;
import com.clustercontrol.jobmanagement.bean.RunStatusConstant;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;

/**
 * ѥåɥ饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class PublicKeyThread extends AgentThread {
	private static final String PUBLIC_KEY = ".public.key";
	private static final String AUTHORIZED_KEY_PATH = ".authorized.keys.path";
	
	//
	private static Log log = LogFactory.getLog(PublicKeyThread.class);
	
	/**
     * 󥹥ȥ饯
     * 
	 * @param props
	 */
	public PublicKeyThread(
			RunInstructionInfo info, 
			SendQueue sendQueue, 
			Hashtable<String, Date> runHistory, 
			Properties props) {
		super(info, sendQueue, runHistory, props);
	}
	
    /* (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    public void run() {
        log.debug("run start");
        
        Date startDate = new Date();
        
        //¹ɲ
		RunHistoryUtil.addRunHistory(m_info, m_runHistory, startDate);
		
        //---------------------------
        //-- ϥå
        //---------------------------
        
        //å
        RunResultInfo info = new RunResultInfo();
        info.setSessionId(m_info.getSessionId());
        info.setJobId(m_info.getJobId());
        info.setFacilityId(m_info.getFacilityId());
        info.setCommand(m_info.getCommand());
        info.setCommandType(m_info.getCommandType());
        info.setUser(m_info.getUser());
        info.setStatus(RunStatusConstant.START);
        info.setTime(startDate);
        
        log.info("run SessionID=" + m_info.getSessionId() + ", JobID=" + m_info.getJobId());
        
        //
        m_sendQueue.put(info);

    	if(m_info.getCommand().equals(CommandConstant.GET_PUBLIC_KEY)){
    		//
    		String key = m_props.getProperty(m_info.getUser().toLowerCase() + PUBLIC_KEY);
    		if(key != null && key.length() > 0){
    			info.setStatus(RunStatusConstant.END);
    			info.setPublicKey(key);
    			info.setTime(new Date());
    			info.setErrorMessage("");
    			info.setMessage("");
    			info.setEndValue(0);
    		}
    		else{
    			info.setStatus(RunStatusConstant.ERROR);
    			info.setPublicKey("");
    			info.setTime(new Date());
    			info.setErrorMessage("");
    			info.setMessage("");
    			info.setEndValue(-1);
    		}
    	}
    	else if(m_info.getCommand().equals(CommandConstant.ADD_PUBLIC_KEY)){
    		//
    		if(addKey(m_info.getPublicKey())){
    			info.setStatus(RunStatusConstant.END);
    	        info.setTime(new Date());
    	        info.setErrorMessage("");
    	        info.setMessage("");
    	        info.setEndValue(0);
    		}
    		else{
    			info.setStatus(RunStatusConstant.ERROR);
    	        info.setTime(new Date());
    	        info.setErrorMessage("");
    	        info.setMessage("");
    	        info.setEndValue(-1);
    		}
    	}
    	else if(m_info.getCommand().equals(CommandConstant.DELETE_PUBLIC_KEY)){
    		//
    		if(deleteKey(m_info.getPublicKey())){
    			info.setStatus(RunStatusConstant.END);
		        info.setTime(new Date());
		        info.setErrorMessage("");
		        info.setMessage("");
		        info.setEndValue(0);
			}
			else{
				info.setStatus(RunStatusConstant.ERROR);
		        info.setTime(new Date());
		        info.setErrorMessage("");
		        info.setMessage("");
		        info.setEndValue(-1);
			}
    	}
        
    	//
		m_sendQueue.put(info);
		
        //¹å
        sendDeleteHistory(info);
        
        log.debug("run end");
    }
	
	/**
     * 
     * 
	 * @param publicKey
	 * @return
	 */
	public synchronized boolean addKey(String publicKey) {
		log.debug("add key start");
		
		//ե̾
		String fileName = m_props.getProperty(m_info.getUser().toLowerCase() + AUTHORIZED_KEY_PATH);
		if(fileName == null || fileName.length() == 0)
			return false;
		
		//File
		File fi = new File(fileName);

		RandomAccessFile randomAccessFile = null;
		FileChannel channel = null;
		FileLock lock = null;
		boolean add = false;
		try {
			//RandomAccessFile
	        randomAccessFile = new RandomAccessFile(fi, "rw");
	        //FileChannel
	        channel = randomAccessFile.getChannel();

	        // եå
	        lock = channel.lock();
	        //եݥǸ˰ư
	        channel.position(channel.size());
	        
	        //ɲʸ
	        String writeData = "\n" + publicKey;
	        
	        //񤭹ѥХåե
	        ByteBuffer buffer = ByteBuffer.allocate(512);
	        
	        //񤭹
	        buffer.clear();
	        buffer.put(writeData.getBytes());
	        buffer.flip();
	        channel.write(buffer);
	
	        add = true;
		} catch (Exception e) {
			log.error(e);
		} finally {
			try {
				if (channel != null) {
					channel.close();
				}
				if (randomAccessFile != null) {
					randomAccessFile.close();
				}
				if (lock != null) {
					//å꡼
					lock.release();
				}
			} catch (Exception e) {
			}
		}
		
		return add;
	}
	
	/**
     * 
     * 
	 * @param publicKey
	 * @return
	 */
	public synchronized boolean deleteKey(String publicKey) {
		log.debug("delete key start");
		
        Charset charset = Charset.forName("UTF-8");
        CharsetEncoder encoder = charset.newEncoder();
        CharsetDecoder decoder = charset.newDecoder();
        
        //ե̾
		String fileName = m_props.getProperty(m_info.getUser().toLowerCase() + AUTHORIZED_KEY_PATH);
		if(fileName == null || fileName.length() == 0)
			return false;
		
		//File
		File fi = new File(fileName);

		RandomAccessFile randomAccessFile = null;
		FileChannel channel = null;
		FileLock lock = null;
		boolean delete = false;
		try {
			//RandomAccessFile
	        randomAccessFile = new RandomAccessFile(fi, "rw");
	        //FileChannel
	        channel = randomAccessFile.getChannel();

	        // եå
	        lock = channel.lock();
	        
	        //Хåե
            ByteBuffer buffer = ByteBuffer.allocate(512);
            
            //եɤ߹
            channel.read(buffer);
            buffer.flip();
            //ʸѴ
            String contents = decoder.decode(buffer).toString();
            
            //
            List<String> keyCheck = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(contents, "\n");
            while (tokenizer.hasMoreTokens()) {
                keyCheck.add(tokenizer.nextToken());
            }
            
            //θȰפΤ
            int s = keyCheck.indexOf(publicKey);
            while(s != -1){
	            keyCheck.remove(s);
	            s = keyCheck.indexOf(publicKey);
			}

            //񤭹ʸκ
            encoder.reset();
            buffer.clear();
            int i;
            if(keyCheck.size() > 0){
	            for (i = 0 ; i < keyCheck.size() - 1 ; i++) {
	                encoder.encode(CharBuffer.wrap((String)keyCheck.get(i) + "\n"), buffer, false);
	            }
	            encoder.encode(CharBuffer.wrap((String)keyCheck.get(i)), buffer, true);
            }
            
            //ե񤭹
            buffer.flip();
            channel.truncate(0);
	        channel.write(buffer);
	
	        delete = true;
		} catch (Exception e) {
			log.error(e);
		} finally {
			try {
				if (channel != null) {
					channel.close();
				}
				if (randomAccessFile != null) {
					randomAccessFile.close();
				}
				//å꡼
				if (lock != null) {
					lock.release();
				}
			} catch (Exception e) {
			}
		}
		
		return delete;
	}
}
