/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.agent.util.RunHistoryUtil;
import com.clustercontrol.jobmanagement.bean.RunStatusConstant;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;

/**
 * ѥåɥ饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class FileListThread extends AgentThread {
	
	//
	private static Log log = LogFactory.getLog(FileListThread.class);
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param props
	 */
	public FileListThread(
			RunInstructionInfo info, 
			SendQueue sendQueue, 
			Hashtable<String, Date> runHistory, 
			Properties props) {
		super(info, sendQueue, runHistory, props);
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		log.debug("run start");
		
        Date startDate = new Date();
        
        //¹ɲ
		RunHistoryUtil.addRunHistory(m_info, m_runHistory, startDate);
		
		//---------------------------
		//-- ϥå
		//---------------------------
		
		//å
		RunResultInfo info = new RunResultInfo();
		info.setSessionId(m_info.getSessionId());
		info.setJobId(m_info.getJobId());
		info.setFacilityId(m_info.getFacilityId());
		info.setCommand(m_info.getCommand());
		info.setCommandType(m_info.getCommandType());
		info.setStatus(RunStatusConstant.START);
		info.setTime(startDate);
		
		log.info("run SessionID=" + m_info.getSessionId() + ", JobID=" + m_info.getJobId());
		
		//
		m_sendQueue.put(info);
		
		//եꥹȼ
		List<String> fileList = getFileList(m_info.getFilePath());
		if(fileList != null && fileList.size() > 0){
			info.setStatus(RunStatusConstant.END);
			info.setFileList(fileList);
			info.setTime(new Date());
			info.setErrorMessage("");
			info.setMessage("");
			info.setEndValue(0);
		}
		else if(fileList != null){
			info.setStatus(RunStatusConstant.END);
			info.setTime(new Date());
			info.setErrorMessage("");
			info.setMessage("");
			info.setEndValue(1);
		}
		else{
			info.setStatus(RunStatusConstant.END);
			info.setTime(new Date());
			info.setErrorMessage("");
			info.setMessage("");
			info.setEndValue(-1);
		}
		
		//
		m_sendQueue.put(info);
		
        //¹å
        sendDeleteHistory(info);
		
		log.debug("run end");
	}
	
	/**
	 * եꥹȼ
	 * 
	 * @param path
	 * @return
	 */
	public synchronized List<String> getFileList(String path) {
		log.debug("get file list start");
		
		List<String> fileList = new ArrayList<String>();
		
		try{
			String dir = path.substring(0, path.lastIndexOf("/") + 1);
			String fileName = path.substring(path.lastIndexOf("/") + 1);
			fileName = fileName.replaceAll("[.]", "[.]");
			fileName = fileName.replaceAll("[*]", ".*");
			if(fileName.length() == 0)
				fileName = ".*";
		
			//FileѥǺ
			File fi = new File(dir);

			File[] files = fi.listFiles();
			for(int i = 0; i < files.length; i++){
				if(files[i].isFile() && !files[i].isHidden()){
					if(files[i].getName().matches(fileName))
						fileList.add(files[i].getCanonicalPath());
				}
			}
		}
		catch(Exception e){
			fileList = null;
		}
		
		log.debug("get file list end");
		return fileList;
	}
}
