/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.agent;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.agent.util.RunHistoryUtil;
import com.clustercontrol.jobmanagement.bean.RunStatusConstant;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;

/**
 * ޥɼ¹ԥåɥ饹
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class CommandThread extends AgentThread {

    protected String m_resultMsg = "";
    protected String m_errMsg = "";
    protected int m_exitValue;
    
    //
	static private Log log = LogFactory.getLog(CommandThread.class);

	/**
	 * ǥХåѥᥤ
	 * 
	 * @param args
	 */
	public static void main(String[] args) {

		CommandThread agent = new CommandThread();
		agent.execCommand(new String[]{"java -version"});
		agent.execCommand(new String[]{"cmd /c \"dir c;\\ /s \" "});
		agent.execCommand(new String[]{"notepad"});

	}
	
	/**
	 * ǥХåѥ󥹥ȥ饯
	 */
	public CommandThread() {
		super();
	}
	
	/**
     * 󥹥ȥ饯
	 * @param info¹Իؼ
	 * @param sendQueue ¹Աѥå饹
	 * @param runHistory ¹
	 */
	public CommandThread(
			RunInstructionInfo info, 
			SendQueue sendQueue, 
			Hashtable<String, Date> runHistory, 
			Properties props) {
		super(info, sendQueue, runHistory, props);
	}
    
    /* (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    public void run() {
        log.debug("run start");
        
        Date startDate = new Date();
        
        //¹ɲ
		RunHistoryUtil.addRunHistory(m_info, m_runHistory, startDate);
		
        //---------------------------
        //-- ϥå
        //---------------------------
        
        
        //å
        RunResultInfo info = new RunResultInfo();
        info.setSessionId(m_info.getSessionId());
        info.setJobId(m_info.getJobId());
        info.setFacilityId(m_info.getFacilityId());
        info.setCommand(m_info.getCommand());
        info.setCommandType(m_info.getCommandType());
        info.setStatus(RunStatusConstant.START);
        info.setTime(startDate);
        
        log.info("run SessionID=" + m_info.getSessionId() + ", JobID=" + m_info.getJobId());
        
        //
        m_sendQueue.put(info);

        
        //---------------------------
        //-- ޥɼ¹
        //---------------------------
        
		//ư桼̾
		String sysUserName = System.getProperty("user.name");
		String execCommand = m_info.getCommand();
		String cmd[] = new String[3];
		if(!sysUserName.equals(m_info.getUser()) ){
		    if( sysUserName.equals("root") ){  
				//ư桼rootξ硢su -c 'ޥ' 桼̾¹Ԥ
				cmd = new String[3];
				cmd[0] = "su";
				cmd[1] = "-c " + execCommand ;
				cmd[2] = m_info.getUser();
		    }else{
		        //ư桼rootʳξ硢顼Ȥ
		        //λ
		        info.setStatus(RunStatusConstant.ERROR);
		        info.setTime(new Date());
		        info.setErrorMessage("The execution user of the command and agent's user are different. ");
		        info.setMessage("");
		        m_sendQueue.put(info);
		        
		        log.error("The execution user of the command and agent's user are different. ");
		        log.info("run end");
		        
		        //¹å
		        sendDeleteHistory(info);
		        return;
		    }
		}else{
		    //ư桼ȼ¹ԥ桼ξϤΤޤ޼¹
			cmd = execCommand.split(" ");

		}

		boolean ret =execCommand(cmd); 

		//---------------------------
        //-- λå
        //---------------------------

		if( ret ){
			
	        info.setStatus(RunStatusConstant.END);
	        info.setEndValue(m_exitValue);
		
		}else{
			
	        info.setStatus(RunStatusConstant.ERROR);
		
		}

        //λ
        info.setTime(new Date());
        info.setErrorMessage(m_errMsg);
        info.setMessage(m_resultMsg);
        m_sendQueue.put(info);
        
        //¹å
        sendDeleteHistory(info);
        
        log.debug("run end");
    }
	/**
	 * ޥɼ¹
	 * 
	 * @param cmd	ޥ
	 * @return	/
	 */
	public boolean execCommand(String cmd[]){
		Runtime runtime = Runtime.getRuntime();

		//ޥɵư
		Process process;

		try {
		    if(log.isInfoEnabled()){
			    for (int i = 0; i < cmd.length; i++) {
	    		    log.info("Command Execute:" + cmd[i]);
	            }
		    }
		    process = runtime.exec(cmd);
		} catch (IOException e) {
			log.error(e);
			m_errMsg = e.getMessage();
			return false;
		}
		try {

		    //ɸϡ顼ɤ߼곫
			StreamReader errStreamReader = new StreamReader(process.getErrorStream());
			errStreamReader.start();
			StreamReader inStreamReader = new StreamReader(process.getInputStream());
			inStreamReader.start();
			
			//ޥɼ¹Ե
			try {
				m_exitValue = process.waitFor();
			} catch (InterruptedException e) {
				log.error(e);
				m_errMsg = e.getMessage();
				return false;
			}

			log.debug("ExitCoe:"+m_exitValue);
			
			//ɸϼ
			try {
				inStreamReader.join();
			} catch (InterruptedException e2) {
			}
			
			m_resultMsg = inStreamReader.getResult();
			log.debug(inStreamReader.getResult());
			
			//顼ϼ
			try {
				errStreamReader.join();
			} catch (InterruptedException e2) {
			}
			
			m_errMsg = errStreamReader.getResult();
			log.debug(m_errMsg);
			
			return true;
		
		}
		finally{
			process.destroy();
		}
		
		
	}
	/**
	 * ¹ԥץɸࡢ顼ɤ߼ꥹå
	 * 󥹥ȥ饯Ϥ줿ȥ꡼ɤ߽ФʸȤƳǼ 
	 */
	protected class StreamReader extends Thread {

		InputStream m_ist;
		StringBuffer m_result;
		
		/**
		 * 󥹥ȥ饯
		 * @param istϥȥ꡼
		 */
		public StreamReader(InputStream ist) {
			super();
			m_ist = ist;
			m_result = new StringBuffer();
		}
		/**
		 * ͥ󥯥
		 */
		public void run() {

			byte[] buff = new byte[64];
			while(true){
				try {
					int length = m_ist.read(buff);
					if( length == -1 )
						break;
					m_result.append(new String(buff, 0, length));
				} catch (IOException e) {
					log.error(e);
					break;
				}
			}

			try {
				m_ist.close();
			} catch (IOException e) {
			}

		}
		/**
		 * ɤ߽Ф̼
		 * @return ȥ꡼फФʸ
		 */
		public String getResult() {
			return m_result.toString();
		}
	}
}
