/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.agent;

import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.agent.util.RunHistoryUtil;
import com.clustercontrol.jobmanagement.bean.CommandTypeConstant;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;

/**
 * ȥåɥ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class AgentThread extends Thread {
	private static Log log = LogFactory.getLog(AgentThread.class);
	
	protected RunInstructionInfo m_info = null;
	protected SendQueue m_sendQueue = null;
	protected Properties m_props = null;
	protected Hashtable<String, Date> m_runHistory = null;
	protected int m_interval = 30;
	
	/**
	 * 󥹥ȥ饯
	 */
	public AgentThread() {
		
	}
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param info
	 * @param sendQueue
	 * @param runHistory
	 * @param props
	 */
	public AgentThread(RunInstructionInfo info, SendQueue sendQueue, Hashtable<String, Date> runHistory, Properties props) {
		m_props = props;
		m_info = info;
		m_sendQueue = sendQueue;
		m_runHistory = runHistory;
		
		//λåֳּ
		String interval = m_props.getProperty("end.message.resend.interval");
		if (interval != null) {
			try {
				m_interval = Integer.parseInt(interval);
			} catch (NumberFormatException e) {
				log.error("end.message.resend.interval",e);
			}
		}
	}
	
	/**
	 * ¹å
	 */
	public void sendDeleteHistory(RunResultInfo info) {
		Date checkDate = new Date();
		
		int commandType = info.getCommandType();
		
		while(true){
			if(RunHistoryUtil.findRunHistory(m_info, m_runHistory) == null){
		        //¹λå
				if(commandType == CommandTypeConstant.NORMAL)
					info.setCommandType(CommandTypeConstant.DELETE_NORMAL_HISTORY);
				else if(commandType == CommandTypeConstant.STOP)
					info.setCommandType(CommandTypeConstant.DELETE_STOP_HISTORY);
		        
		        log.info("delete history SessionID=" + m_info.getSessionId() + ", JobID=" + m_info.getJobId());
		        
		        //
		        m_sendQueue.put(info);

		        break;
			}
			else{
				Calendar checkTime = Calendar.getInstance();
				checkTime.setTime(checkDate);
				checkTime.add(Calendar.SECOND, m_interval);
				Date now = new Date();
				
				if(now.after(checkTime.getTime())){
			        //λåå
					info.setCommandType(commandType);
	
			        //
			        m_sendQueue.put(info);
			        
			        checkDate = new Date();
				}
			}
			
			try {
				sleep(1000);
			} catch (InterruptedException e) {
			}
		}
	}
}
