/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.util;

import java.io.IOException;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

import com.clustercontrol.util.apllog.AplLogger;

/**
 * LDAPȤΥͥ륯饹
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class LdapConnectionManager {
    protected static Log m_log = LogFactory.getLog( LdapConnectionManager.class );

    private static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	private static final String OBJECT_NAME = "user:name=TroubleDetection,service=TroubleDetectionService";
	private static final String OPERATION_NAME = "putMessage";
    
    private static boolean m_provider = false;
    private static boolean m_consumer = false;
    
	private static LdapConnectionManager m_instance = null;

	/**
	 * Υ֥Ȥޤ
	 * 
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @return ConnectionManager ͥޥ͡
	 */
	public static LdapConnectionManager getConnectionManager() {
		if (m_instance==null) {
			m_instance = new LdapConnectionManager();
		}
		return m_instance;
	}

	/**
	 * 󥹥ȥ饯
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 */
	private LdapConnectionManager() {

	}
	
	/**
	 * ƥȤޤ
	 * 
	 * @version 2.1.0
	 * @since 1.0.0
	 * 
	 * @returnDirContext ƥ
	 */
	public javax.naming.directory.DirContext getDirContext() {
		javax.naming.directory.DirContext ctx = null;
		try {
			
			//ץХLDAPѤΥƥȤκ
			InitialContext iniCtx = new InitialContext();
			ctx = (InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/provider");
			
			//󥷥塼ޤڤؤä硢
			if(m_consumer){
				outputLog("LDAP03", "001");
			}
			
			m_provider = true;
			m_consumer = false;
			
		} catch (NamingException e) {
			m_log.debug("LdapConnectionManager() : LDAP Connection Error : " + e.getMessage());
			
			try {
				
				//󥷥塼LDAPѤΥƥȤκ
				InitialContext iniCtx = new InitialContext();
				ctx = (InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/consumer");
				
				//ץХڤؤä硢
				if(m_provider){
					outputLog("LDAP02", "001");
				}
				m_provider = false;
				m_consumer = true;
				
			} catch (NamingException e1) {
				m_log.debug("LdapConnectionManager() : LDAP Connection Error : " + e1.getMessage());
				
			}
		}

		if(ctx == null){
			AplLogger apllog = new AplLogger("REP", "rep");
			apllog.put("SYS", "001");
			
			//
			if(m_provider){
				outputLog("LDAP02", "002");
			}
			else{
				outputLog("LDAP03", "002");
			}
			
		    m_provider = false;
		    m_consumer = false;
		}
		
		return ctx;
	}
	
	/**
	 * ƥȤꤷޤ
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param ctx ƥ
	 */
	public void setDirContext(javax.naming.directory.DirContext ctx) {
//	    try {
//            m_ctx.close();
//        } catch (NamingException e) {
//
//        }
//		m_ctx = ctx;
	}
	
	/**
	 * 
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param messageId
	 */
	private void outputLog(String monitorId, String messageId) {

		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptor
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectName
	        ObjectName name = new ObjectName(OBJECT_NAME);
	        
	        //ObjectNameOperationNameΥ᥽åɤ¹
	        Object[] args = {monitorId, messageId};
	        String[] signature = {String.class.getName(), String.class.getName()};
	        server.invoke(name, OPERATION_NAME, args, signature);

		} catch (NamingException e) {
			m_log.debug("outputLog() : " + e.getMessage());
		} catch (MalformedObjectNameException e) {
			m_log.debug("outputLog() : " + e.getMessage());
		} catch (NullPointerException e) {
			m_log.debug("outputLog() : " + e.getMessage());
		} catch (InstanceNotFoundException e) {
			m_log.debug("outputLog() : " + e.getMessage());
		} catch (MBeanException e) {
			m_log.debug("outputLog() : " + e.getMessage());
		} catch (ReflectionException e) {
			m_log.debug("outputLog() : " + e.getMessage());
		} catch (IOException e) {
			m_log.debug("outputLog() : " + e.getMessage());
		}
	}
}
