/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.accesscontrol.bean.RoleConstant;
import com.clustercontrol.accesscontrol.ejb.entity.RoleLocal;
import com.clustercontrol.accesscontrol.ejb.entity.UserLocal;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * 桼ѥץѥƥ饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class UserProperty extends RoleConstant{
	/** UID */
	public static final String UID = "uid";
	/** ̾ */
	public static final String NAME = "namae";
	/**  */
	public static final String DESCRIPTION = "description";
	/**  */
	public static final String CREATE_TIME = "createTimestamp";
	/**  */
	public static final String CREATOR_NAME = "creatorName";
	/**  */
	public static final String MODIFIER_NAME = "ModifierName";
	/**  */
	public static final String MODIFY_TIME = "ModifyTime";
	
	/**  */
	public static final String ACCESS = "access";
	
	/**
	 * 桼ѥץѥƥ֤ޤ
	 * 
	 * @param uid
	 * @param mode
	 * @param local
	 * @return 桼ѥץѥƥ
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getProperty(String uid, int mode, Locale local) throws FinderException, NamingException {
		Property property = getProperty(mode, local);
		
		if(uid != null && uid.compareTo("") != 0){
		    //User
			SelectUser select = new SelectUser();
			UserLocal user = select.getUser(uid);
			
			if(user != null){
				//UID
				ArrayList propertyList = PropertyUtil.getProperty(property, UID);
				((Property)propertyList.get(0)).setValue(user.getUid());
				//̾
				propertyList = PropertyUtil.getProperty(property, NAME);
				if(user.getCn() != null && user.getCn().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(user.getCn());
				}
				//
				propertyList = PropertyUtil.getProperty(property, DESCRIPTION);
				if(user.getDescription() != null && user.getDescription().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(user.getDescription());
				}
				//Ͽ
				propertyList = PropertyUtil.getProperty(property, CREATOR_NAME);
				if(user.getCreatorsName() != null && user.getCreatorsName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(user.getCreatorsName());
				}
				//Ͽ
				propertyList = PropertyUtil.getProperty(property, CREATE_TIME);
				if(user.getCreateTimestamp() != null){
					((Property)propertyList.get(0)).setValue(user.getCreateTimestamp());
				}
				//
				propertyList = PropertyUtil.getProperty(property, MODIFIER_NAME);
				if(user.getModifiersName() != null && user.getModifiersName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(user.getModifiersName());
				}
				//
				propertyList = PropertyUtil.getProperty(property, MODIFY_TIME);
				if(user.getModifyTimestamp() != null){
					((Property)propertyList.get(0)).setValue(user.getModifyTimestamp());
				}
				
				//
				propertyList = PropertyUtil.getProperty(property, ACCESS);
				Property accessProperty = (Property)propertyList.get(0);
				
				//°Role
				Collection roles = null;
				try {
					roles = user.getRoles();
				} catch (FinderException e) {
				}
				if(roles != null){
					List<String> roleList = RoleConstant.getRoles();
					Iterator itr = roles.iterator();
					while(itr.hasNext()){
						RoleLocal role = (RoleLocal)itr.next();
						
						for(int i = 0; i < roleList.size(); i++){
							String roleName = roleList.get(i);
							if(role.getCn().compareTo(roleName) == 0){
								propertyList = PropertyUtil.getProperty(accessProperty, roleName);
								if(propertyList.size() > 0){
									((Property)propertyList.get(0)).setValue(new Boolean(true));
								}
							}
						}
					}
				}
			}
		}
		
		return property;
	}
	
	/**
	 * 桼ѥץѥƥ֤ޤ
	 * 
	 * @param mode
	 * @return 桼ѥץѥƥ
	 */
	public Property getProperty(int mode, Locale local) {
	    //UID
		Property uid =
			new Property(UID, Messages.getString("user.id", local), PropertyConstant.EDITOR_TEXT);
		//̾
		Property name =
			new Property(NAME, Messages.getString("name", local), PropertyConstant.EDITOR_TEXT);
		//
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", local), PropertyConstant.EDITOR_TEXT);
		//Ͽ
		Property createTime =
			new Property(CREATE_TIME, Messages.getString("create.time", local), PropertyConstant.EDITOR_DATETIME);
		//Ͽ
		Property creatorName =
			new Property(CREATOR_NAME, Messages.getString("creator.name", local), PropertyConstant.EDITOR_TEXT);
		//
		Property modifyTime =
			new Property(MODIFY_TIME, Messages.getString("update.time", local), PropertyConstant.EDITOR_DATETIME);
		//
		Property modifierName =
			new Property(MODIFIER_NAME, Messages.getString("modifier.name", local), PropertyConstant.EDITOR_TEXT);

		//
		Property access =
			new Property(ACCESS, Messages.getString("access.permission", local), PropertyConstant.EDITOR_TEXT);
		//ݥȥ껲
		Property repositoryRead =
			new Property(REPOSITORY_READ, Messages.getString("repository.read", local), PropertyConstant.EDITOR_BOOL);
		//ݥȥ
		Property repositoryWrite =
			new Property(REPOSITORY_WRITE, Messages.getString("repository.write", local), PropertyConstant.EDITOR_BOOL);
		//
		Property accessRead =
			new Property(ACCESSCONTROL_READ, Messages.getString("accesscontrol.read", local), PropertyConstant.EDITOR_BOOL);
		//
		Property accessWrite =
			new Property(ACCESSCONTROL_WRITE, Messages.getString("accesscontrol.write", local), PropertyConstant.EDITOR_BOOL);
		//ִƻ뻲
		Property monitorRead =
			new Property(MONITOR_READ, Messages.getString("monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//ִƻ
		Property monitorWrite =
			new Property(MONITOR_WRITE, Messages.getString("monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//ִ
		Property jobManagementRead =
			new Property(JOBMANAGEMENT_READ, Messages.getString("jobmanagement.read", local), PropertyConstant.EDITOR_BOOL);
		//
		Property jobManagementWrite =
			new Property(JOBMANAGEMENT_WRITE, Messages.getString("jobmanagement.write", local), PropertyConstant.EDITOR_BOOL);
		//ּ¹
		Property jobManagementExecute =
			new Property(JOBMANAGEMENT_EXECUTE, Messages.getString("jobmanagement.execute", local), PropertyConstant.EDITOR_BOOL);
		//ǽ
		Property performanceRead =
			new Property(PERFORMANCE_READ, Messages.getString("performance.read", local), PropertyConstant.EDITOR_BOOL);
		//ǽ
		Property performanceWrite =
			new Property(PERFORMANCE_WRITE, Messages.getString("performance.write", local), PropertyConstant.EDITOR_BOOL);
		//ǽ¹
		Property performanceExecute =
			new Property(PERFORMANCE_EXECUTE, Messages.getString("performance.execute", local), PropertyConstant.EDITOR_BOOL);
		//滲
		Property collectiverunRead =
			new Property(COLLECTIVERUN_READ, Messages.getString("collectiverun.read", local), PropertyConstant.EDITOR_BOOL);
		//
		Property collectiverunWrite =
			new Property(COLLECTIVERUN_WRITE, Messages.getString("collectiverun.write", local), PropertyConstant.EDITOR_BOOL);
		//¹
		Property collectiverunExecute =
			new Property(COLLECTIVERUN_EXECUTE, Messages.getString("collectiverun.execute", local), PropertyConstant.EDITOR_BOOL);
		//SyslogNGƻ뻲
		Property syslogngMonitorRead =
			new Property(SYSLOGNG_MONITOR_READ, Messages.getString("syslogng.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//SyslogNGƻ
		Property syslogngMonitorWrite =
			new Property(SYSLOGNG_MONITOR_WRITE, Messages.getString("syslogng.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//Pingƻ뻲
		Property pingMonitorRead =
			new Property(PING_MONITOR_READ, Messages.getString("ping.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//Pingƻ
		Property pingMonitorWrite =
			new Property(PING_MONITOR_WRITE, Messages.getString("ping.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//ץƻ뻲
		Property processMonitorRead =
			new Property(PROCESS_MONITOR_READ, Messages.getString("process.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//ץƻ
		Property processMonitorWrite =
			new Property(PROCESS_MONITOR_WRITE, Messages.getString("process.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//SNMPƻ뻲
		Property snmpMonitorRead =
			new Property(SNMP_MONITOR_READ, Messages.getString("snmp.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//SNMPƻ
		Property snmpMonitorWrite =
			new Property(SNMP_MONITOR_WRITE, Messages.getString("snmp.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//SNMPTRAPƻ뻲
		Property snmptrapMonitorRead =
			new Property(SNMPTRAP_MONITOR_READ, Messages.getString("snmptrap.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//SNMPTRAPƻ
		Property snmptrapMonitorWrite =
			new Property(SNMPTRAP_MONITOR_WRITE, Messages.getString("snmptrap.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//SQLƻ뻲
		Property sqlMonitorRead =
			new Property(SQL_MONITOR_READ, Messages.getString("sql.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//SQLƻ
		Property sqlMonitorWrite =
			new Property(SQL_MONITOR_WRITE, Messages.getString("sql.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//ȴƻ뻲
		Property agentMonitorRead =
			new Property(AGENT_MONITOR_READ, Messages.getString("agent.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//ȴƻ
		Property agentMonitorWrite =
			new Property(AGENT_MONITOR_WRITE, Messages.getString("agent.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//HTTPƻ뻲
		Property httpMonitorRead =
			new Property(HTTP_MONITOR_READ, Messages.getString("http.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//HTTPƻ
		Property httpMonitorWrite =
			new Property(HTTP_MONITOR_WRITE, Messages.getString("http.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//ž
		Property logTransferRead =
			new Property(LOG_TRANSFER_READ, Messages.getString("logtransfer.read", local), PropertyConstant.EDITOR_BOOL);
		//ž
		Property logTransferWrite =
			new Property(LOG_TRANSFER_WRITE, Messages.getString("logtransfer.write", local), PropertyConstant.EDITOR_BOOL);
		//
		Property calendarRead =
			new Property(CALENDAR_READ, Messages.getString("calendar.read", local), PropertyConstant.EDITOR_BOOL);
		//
		Property calendarWrite =
			new Property(CALENDAR_WRITE, Messages.getString("calendar.write", local), PropertyConstant.EDITOR_BOOL);
		//λ
		Property notifyRead =
			new Property(NOTIFY_READ, Messages.getString("notify.id.read", local), PropertyConstant.EDITOR_BOOL);
		//
		Property notifyWrite =
			new Property(NOTIFY_WRITE, Messages.getString("notify.id.write", local), PropertyConstant.EDITOR_BOOL);
		//Ƚ껲
		Property priorityJudgmentRead =
			new Property(PRIORITY_JUDGMENT_READ, Messages.getString("priority.judgment.read", local), PropertyConstant.EDITOR_BOOL);
		//Ƚ
		Property priorityJudgmentWrite =
			new Property(PRIORITY_JUDGMENT_WRITE, Messages.getString("priority.judgment.write", local), PropertyConstant.EDITOR_BOOL);
		//㳲λ
		Property troubleDetectionRead =
			new Property(TROUBLE_DETECTION_READ, Messages.getString("trouble.detection.read", local), PropertyConstant.EDITOR_BOOL);
		//㳲
		Property troubleDetectionWrite =
			new Property(TROUBLE_DETECTION_WRITE, Messages.getString("trouble.detection.write", local), PropertyConstant.EDITOR_BOOL);
		
		
		//ͤ
		uid.setValue("");
		name.setValue("");
		description.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");
		
		access.setValue("");
		repositoryRead.setValue(new Boolean(true));
		repositoryWrite.setValue(new Boolean(false));
		accessRead.setValue(new Boolean(false));
		accessWrite.setValue(new Boolean(false));
		monitorRead.setValue(new Boolean(false));
		monitorWrite.setValue(new Boolean(false));
		jobManagementRead.setValue(new Boolean(false));
		jobManagementWrite.setValue(new Boolean(false));
		jobManagementExecute.setValue(new Boolean(false));
		performanceRead.setValue(new Boolean(false));
		performanceWrite.setValue(new Boolean(false));
		performanceExecute.setValue(new Boolean(false));
		collectiverunRead.setValue(new Boolean(false));
		collectiverunWrite.setValue(new Boolean(false));
		collectiverunExecute.setValue(new Boolean(false));
		syslogngMonitorRead.setValue(new Boolean(false));
		syslogngMonitorWrite.setValue(new Boolean(false));
		pingMonitorRead.setValue(new Boolean(false));
		pingMonitorWrite.setValue(new Boolean(false));
		processMonitorRead.setValue(new Boolean(false));
		processMonitorWrite.setValue(new Boolean(false));
		snmpMonitorRead.setValue(new Boolean(false));
		snmpMonitorWrite.setValue(new Boolean(false));
		snmptrapMonitorRead.setValue(new Boolean(false));
		snmptrapMonitorWrite.setValue(new Boolean(false));
		sqlMonitorRead.setValue(new Boolean(false));
		sqlMonitorWrite.setValue(new Boolean(false));
		agentMonitorRead.setValue(new Boolean(false));
		agentMonitorWrite.setValue(new Boolean(false));
		httpMonitorRead.setValue(new Boolean(false));
		httpMonitorWrite.setValue(new Boolean(false));
		logTransferRead.setValue(new Boolean(false));
		logTransferWrite.setValue(new Boolean(false));
		calendarRead.setValue(new Boolean(false));
		calendarWrite.setValue(new Boolean(false));
		notifyRead.setValue(new Boolean(false));
		notifyWrite.setValue(new Boolean(false));
		priorityJudgmentRead.setValue(new Boolean(false));
		priorityJudgmentWrite.setValue(new Boolean(false));
		troubleDetectionRead.setValue(new Boolean(false));
		troubleDetectionWrite.setValue(new Boolean(false));

		//⡼ɤˤꡢѹĵڤӥԡĤ
		if(mode == PropertyConstant.MODE_ADD){
			uid.setModify(PropertyConstant.MODIFY_OK);
			name.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
			repositoryWrite.setModify(PropertyConstant.MODIFY_OK);
			accessRead.setModify(PropertyConstant.MODIFY_OK);
			accessWrite.setModify(PropertyConstant.MODIFY_OK);
			monitorRead.setModify(PropertyConstant.MODIFY_OK);
			monitorWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementRead.setModify(PropertyConstant.MODIFY_OK);
			jobManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementExecute.setModify(PropertyConstant.MODIFY_OK);
			performanceRead.setModify(PropertyConstant.MODIFY_OK);
			performanceWrite.setModify(PropertyConstant.MODIFY_OK);
			performanceExecute.setModify(PropertyConstant.MODIFY_OK);
			collectiverunRead.setModify(PropertyConstant.MODIFY_OK);
			collectiverunWrite.setModify(PropertyConstant.MODIFY_OK);
			collectiverunExecute.setModify(PropertyConstant.MODIFY_OK);
			syslogngMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			syslogngMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			pingMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			pingMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			processMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			processMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			snmpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			snmpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			snmptrapMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			snmptrapMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			sqlMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			sqlMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			agentMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			agentMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			httpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			httpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			logTransferRead.setModify(PropertyConstant.MODIFY_OK);
			logTransferWrite.setModify(PropertyConstant.MODIFY_OK);
			calendarRead.setModify(PropertyConstant.MODIFY_OK);
			calendarWrite.setModify(PropertyConstant.MODIFY_OK);
			notifyRead.setModify(PropertyConstant.MODIFY_OK);
			notifyWrite.setModify(PropertyConstant.MODIFY_OK);
			priorityJudgmentRead.setModify(PropertyConstant.MODIFY_OK);
			priorityJudgmentWrite.setModify(PropertyConstant.MODIFY_OK);
			troubleDetectionRead.setModify(PropertyConstant.MODIFY_OK);
			troubleDetectionWrite.setModify(PropertyConstant.MODIFY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			name.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
			repositoryWrite.setModify(PropertyConstant.MODIFY_OK);
			accessRead.setModify(PropertyConstant.MODIFY_OK);
			accessWrite.setModify(PropertyConstant.MODIFY_OK);
			monitorRead.setModify(PropertyConstant.MODIFY_OK);
			monitorWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementRead.setModify(PropertyConstant.MODIFY_OK);
			jobManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementExecute.setModify(PropertyConstant.MODIFY_OK);
			performanceRead.setModify(PropertyConstant.MODIFY_OK);
			performanceWrite.setModify(PropertyConstant.MODIFY_OK);
			performanceExecute.setModify(PropertyConstant.MODIFY_OK);
			collectiverunRead.setModify(PropertyConstant.MODIFY_OK);
			collectiverunWrite.setModify(PropertyConstant.MODIFY_OK);
			collectiverunExecute.setModify(PropertyConstant.MODIFY_OK);
			syslogngMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			syslogngMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			snmptrapMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			snmptrapMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			pingMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			pingMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			processMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			processMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			snmpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			snmpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			sqlMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			sqlMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			agentMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			agentMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			httpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			httpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			logTransferRead.setModify(PropertyConstant.MODIFY_OK);
			logTransferWrite.setModify(PropertyConstant.MODIFY_OK);
			calendarRead.setModify(PropertyConstant.MODIFY_OK);
			calendarWrite.setModify(PropertyConstant.MODIFY_OK);
			notifyRead.setModify(PropertyConstant.MODIFY_OK);
			notifyWrite.setModify(PropertyConstant.MODIFY_OK);
			priorityJudgmentRead.setModify(PropertyConstant.MODIFY_OK);
			priorityJudgmentWrite.setModify(PropertyConstant.MODIFY_OK);
			troubleDetectionRead.setModify(PropertyConstant.MODIFY_OK);
			troubleDetectionWrite.setModify(PropertyConstant.MODIFY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		// ɽĥ꡼
		property.removeChildren();
		property.addChildren(uid);
		property.addChildren(name);
		property.addChildren(description);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);
		property.addChildren(access);
		
		// ¥ĥ꡼
		access.removeChildren();
		access.addChildren(repositoryRead);
		access.addChildren(repositoryWrite);
		access.addChildren(accessRead);
		access.addChildren(accessWrite);
		access.addChildren(monitorRead);
		access.addChildren(monitorWrite);
		access.addChildren(jobManagementRead);
		access.addChildren(jobManagementWrite);
		access.addChildren(jobManagementExecute);
		access.addChildren(performanceRead);
		access.addChildren(performanceWrite);
		access.addChildren(performanceExecute);
		access.addChildren(collectiverunRead);
		access.addChildren(collectiverunWrite);
		access.addChildren(collectiverunExecute);
		access.addChildren(syslogngMonitorRead);
		access.addChildren(syslogngMonitorWrite);
		access.addChildren(pingMonitorRead);
		access.addChildren(pingMonitorWrite);
		access.addChildren(processMonitorRead);
		access.addChildren(processMonitorWrite);
		access.addChildren(snmpMonitorRead);
		access.addChildren(snmpMonitorWrite);
		access.addChildren(snmptrapMonitorRead);
		access.addChildren(snmptrapMonitorWrite);
		access.addChildren(sqlMonitorRead);
		access.addChildren(sqlMonitorWrite);
		access.addChildren(agentMonitorRead);
		access.addChildren(agentMonitorWrite);
		access.addChildren(httpMonitorRead);
		access.addChildren(httpMonitorWrite);
		access.addChildren(logTransferRead);
		access.addChildren(logTransferWrite);
		access.addChildren(calendarRead);
		access.addChildren(calendarWrite);
		access.addChildren(notifyRead);
		access.addChildren(notifyWrite);
		access.addChildren(priorityJudgmentRead);
		access.addChildren(priorityJudgmentWrite);
		
		String serverName = System.getProperty("jboss.server.name");
		if(serverName.equals("all")){
			access.addChildren(troubleDetectionRead);
			access.addChildren(troubleDetectionWrite);
		}
		
		return property;
	}
}
