/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.accesscontrol.bean.RoleConstant;
import com.clustercontrol.accesscontrol.ejb.entity.RoleLocal;
import com.clustercontrol.accesscontrol.ejb.entity.RoleUtil;
import com.clustercontrol.accesscontrol.ejb.entity.UserLocal;
import com.clustercontrol.accesscontrol.ejb.entity.UserUtil;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.PropertyUtil;

/**
 * 桼饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class SelectUser {

    /**
     * 桼
     * 
     * ֥Ȥ2Ȥ֤
     * 
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    @SuppressWarnings("unchecked")
	public ArrayList getUserList() throws FinderException, NamingException {
        ArrayList list = null;
        try {
            //Userȥ
            Collection ct = UserUtil.getLocalHome().findAll();
            
            list = new ArrayList();
            Iterator itr = ct.iterator();
            while(itr.hasNext()){
                UserLocal user = (UserLocal)itr.next();
                
                ArrayList info = new ArrayList();
                info.add(user.getUid());
                info.add(user.getCn());
                info.add(user.getDescription());
                info.add(user.getCreatorsName());
                info.add(user.getCreateTimestamp());
                info.add(user.getModifiersName());
                info.add(user.getModifyTimestamp());
                list.add(info);
            }
        } catch (FinderException e) {
            throw e;
        } catch (NamingException e) {
            throw e;
        }
        
        return list;
    }
    
    /**
     * 桼
     * 
     * ֥Ȥ2Ȥ֤
     * 
     * @param property
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    @SuppressWarnings("unchecked")
    public ArrayList getUserList(Property property) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            ArrayList values = null;
            //UID
            values = PropertyUtil.getPropertyValue(property, UserFilterProperty.UID);
            String uid = (String)values.get(0);
            //̾
            values = PropertyUtil.getPropertyValue(property, UserFilterProperty.NAME);
            String name = (String)values.get(0);
            //
            values = PropertyUtil.getPropertyValue(property, UserFilterProperty.DESCRIPTION);
            String description = (String)values.get(0);
            
            //
            List<String> accessList = new ArrayList<String>();
			List<String> roleList = RoleConstant.getRoles();
			for(int i = 0; i < roleList.size(); i++){
				String roleName = roleList.get(i);
				
				values = PropertyUtil.getPropertyValue(property, roleName);
				if(values.size() > 0 && ((Boolean)values.get(0)).booleanValue()){
					accessList.add(roleName);
				}
			}
			
            //UserκǾ̤鸡
            Collection ct = 
                UserUtil.getLocalHome().findUser(
                		uid, 
                		name, 
                        description, 
                        accessList);
            
            list = new ArrayList();
            Iterator itr = ct.iterator();
            while(itr.hasNext()){
                UserLocal user = (UserLocal)itr.next();
                
                ArrayList info = new ArrayList();
                info.add(user.getUid());
                info.add(user.getCn());
                info.add(user.getDescription());
                info.add(user.getCreatorsName());
                info.add(user.getCreateTimestamp());
                info.add(user.getModifiersName());
                info.add(user.getModifyTimestamp());
                list.add(info);
            }
        } catch (FinderException e) {
            throw e;
        } catch (NamingException e) {
            throw e;
        }
        
        return list;
    }
    
    /**
     * 桼
     * 
     * @param uid
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    public UserLocal getUser(String uid) throws FinderException, NamingException {
    	UserLocal user = null;
        try {
            //Userȥ
        	user = UserUtil.getLocalHome().findByUid(uid);
        } catch (FinderException e) {
            throw e;
        } catch (NamingException e) {
            throw e;
        }
        
        return user;
    }
    
    /**
     * 
     * 
     * @param roleName
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    public RoleLocal getRole(String roleName) throws FinderException, NamingException {
    	RoleLocal role = null;
        try {
            //Userȥ
        	role = RoleUtil.getLocalHome().findByCn(roleName);
        } catch (FinderException e) {
            throw e;
        } catch (NamingException e) {
            throw e;
        }
        
        return role;
    }
    
    /**
     * 桼̾
     * 
     * @param uid
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    public String getUserName(String uid) throws FinderException, NamingException {
    	String userName = null;
        try {
            //Userȥ
        	UserLocal user = UserUtil.getLocalHome().findByUid(uid);
        	// ̾
			if(user.getCn() != null && user.getCn().compareTo("") != 0){
				userName = user.getCn();
			}
        } catch (FinderException e) {
            throw e;
        } catch (NamingException e) {
            throw e;
        }
        
        return userName;
    }
}
