/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.factory;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

import com.clustercontrol.accesscontrol.bean.RoleConstant;
import com.clustercontrol.accesscontrol.ejb.entity.RoleLocal;
import com.clustercontrol.accesscontrol.ejb.entity.RoleUtil;
import com.clustercontrol.accesscontrol.ejb.entity.UserLocal;
import com.clustercontrol.accesscontrol.ejb.entity.UserUtil;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * 桼饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyUser {
	protected static Log m_log = LogFactory.getLog(ModifyUser.class);
	
	public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	public static final String OBJECT_NAME = "jboss.security:service=JaasSecurityManager";
	public static final String OPERATION_NAME = "flushAuthenticationCache";
	
	/**
	 * 桼ɲ
	 *  
	 * @param property
	 * @param userName
	 * @throws NamingException
	 * @throws CreateException
	 * @throws FinderException
	 * @throws ParseException
	 */
	public void addUser(Property property, String userName) throws NamingException, CreateException, FinderException, ParseException  {
    	//å
    	AccessLock.lock(AccessLock.ACCESS);
		
		String uid = null;
	    try {
			ArrayList values = null;
			//
			Date now = new Date();
			
			//UID
			values = PropertyUtil.getPropertyValue(property, UserProperty.UID);
			uid = (String)values.get(0);
			//UIDͭå
			checkValidUid(uid);
					
			//User
			UserLocal user = UserUtil.getLocalHome().create(uid);

			//̾User
			values = PropertyUtil.getPropertyValue(property, UserProperty.NAME);
			user.setCn(checkString(values.get(0)));
			//User
			values = PropertyUtil.getPropertyValue(property, UserProperty.DESCRIPTION);
			user.setDescription(checkString(values.get(0)));
			//ԤUser
			user.setCreatorsName(checkString(userName));
			//User
			user.setCreateTimestamp(now);
			//ԤUser
			user.setModifiersName(checkString(userName));
			//User
			user.setModifyTimestamp(now);

			//HinemosUser
			assignUser(RoleConstant.HINEMOS_USER, user.getDn());
			
			//User
			List<String> roleList = RoleConstant.getRoles();
			for(int i = 0; i < roleList.size(); i++){
				String roleName = roleList.get(i);
				
				values = PropertyUtil.getPropertyValue(property, roleName);
				if(values.size() > 0 && ((Boolean)values.get(0)).booleanValue()){
					assignUser(roleName, user.getDn());
				}
			}
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {uid};
            apllog.put("SYS", "006", args);
            
            m_log.debug("addUser() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {uid};
            apllog.put("SYS", "006", args);
            
            m_log.debug("addUser() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {uid};
            apllog.put("SYS", "006", args);
            
            m_log.debug("addUser() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * 桼ѹ
	 * 
	 * @param property
	 * @param userName
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyUser(Property property, String userName) throws NamingException, FinderException {
    	//å
    	AccessLock.lock(AccessLock.ACCESS);
    	
    	String uid = null;
	    try {
			ArrayList values = null;
			Date now = new Date();
			
			//UID
			values = PropertyUtil.getPropertyValue(property, UserProperty.UID);
			uid = (String)values.get(0);
			
			//User򸡺
			UserLocal user = UserUtil.getLocalHome().findByUid(uid);
			//̾User
			values = PropertyUtil.getPropertyValue(property, UserProperty.NAME);
			user.setCn(checkString(values.get(0)));
			//User
			values = PropertyUtil.getPropertyValue(property, UserProperty.DESCRIPTION);
			user.setDescription(checkString(values.get(0)));
			//ԤUser
			user.setModifiersName(checkString(userName));
			//User
			user.setModifyTimestamp(now);
			
			//User
			List<String> roleList = RoleConstant.getRoles();
			for(int i = 0; i < roleList.size(); i++){
				String roleName = roleList.get(i);
				
				values = PropertyUtil.getPropertyValue(property, roleName);
				if(values.size() > 0){
					releaseUser(roleName, user.getDn());
					if(((Boolean)values.get(0)).booleanValue()){
						assignUser(roleName, user.getDn());
					}
				}
			}
			
			//ǧڥå幹
			flushAuthenticationCache();
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {uid};
            apllog.put("SYS", "008", args);
            
            m_log.debug("modifyUser() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {uid};
            apllog.put("SYS", "008", args);
            
            m_log.debug("modifyUser() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * 桼
	 * 
	 * @param property
	 * @param userName
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void deleteUser(String uid) throws NamingException, RemoveException, FinderException {
    	//å
    	AccessLock.lock(AccessLock.ACCESS);
    	
		try {
			//User򸡺
			UserLocal user = UserUtil.getLocalHome().findByUid(uid);
			String dn = user.getDn();
			user.remove();
			
			//User
			List<String> roleList = RoleConstant.getRoles();
			for(int i = 0; i < roleList.size(); i++){
				String roleName = roleList.get(i);
				releaseUser(roleName, dn);
			}
			
			//ǧڥå幹
			flushAuthenticationCache();

		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {uid};
            apllog.put("SYS", "007", args);
            
            m_log.debug("deleteUser() : " + e.getMessage());
			throw e;
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {uid};
            apllog.put("SYS", "007", args);
            
            m_log.debug("deleteUser() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {uid};
            apllog.put("SYS", "007", args);
            
            m_log.debug("deleteUser() : " + e.getMessage());
			throw e;
		}
	}
	
    /**
     * ˥桼
     * 
     * @param roleName
     * @param dn
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    @SuppressWarnings("unchecked")
	protected void assignUser(String roleName, String dn) throws FinderException, NamingException {
    	RoleLocal role = null;
        try {
            //Roleȥ
        	role = RoleUtil.getLocalHome().findByCn(roleName);
        	
        	//UserDNɲ
        	ArrayList list = role.getMember();
        	if(list == null){
        		list = new ArrayList();
        	}
        	list.add(dn);
        	role.setMember(list);
        	
        } catch (FinderException e) {
            throw e;
        } catch (NamingException e) {
            throw e;
        }
    }
    
    /**
     * 뤫桼
     * 
     * @param roleName
     * @param dn
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    protected void releaseUser(String roleName, String dn) throws FinderException, NamingException {
    	RoleLocal role = null;
        try {
            //Roleȥ
        	role = RoleUtil.getLocalHome().findByCn(roleName);
        	
        	//UserDN
        	String userDn = dn;
        	ArrayList list = role.getMember();
        	if(list != null){
	        	for(int i = 0; i < list.size(); i++){
	        		if(userDn.equalsIgnoreCase((String)list.get(i))){
	        			list.remove(i);
	        			break;
	        		}
	        	}
	        	role.setMember(list);
        	}
        	else{
        		role.setMember(null);
        	}
        } catch (FinderException e) {
            throw e;
        } catch (NamingException e) {
            throw e;
        }
    }
    
    /**
     * 桼Υѥѹ
     * 
     * @param uid
     * @param Password
     * @return
     * @throws FinderException 
     * @throws NamingException 
     */
    public void modifyPassword(String uid, String password) throws FinderException, NamingException {
    	//å
    	AccessLock.lock(AccessLock.ACCESS);
    	
    	try {
			//User򸡺
			UserLocal user = UserUtil.getLocalHome().findByUid(uid);
			
			//ѥɤ
			user.setPassword(password);
			
			//ǧڥå幹
			flushAuthenticationCache();

		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {uid};
            apllog.put("SYS", "009", args);
            
            m_log.debug("modifyPassword() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            String[] args = {uid};
            apllog.put("SYS", "008", args);
            
            m_log.debug("modifyPassword() : " + e.getMessage());
			throw e;
		}
    }
	
	/**
	 * IntegerΥ󥹥󥹤åäƤnull֤
	 * 
	 * @param value
	 * @return
	 */
    private Integer checkInteger(Object value){
		if(value instanceof Integer){
			return (Integer)value;
		}
		else{
			return null;
		}
	}
	
	/**
	 * StringΥ󥹥󥹤åäƤnull֤
	 * 
	 * @param value
	 * @return
	 */
    private String checkString(Object value){
		if(value instanceof String){
			if(((String)value).compareTo("") == 0){
				return null;
			}
			else{
				return (String)value;
			}
		}
		else{
			return null;
		}
	}
	
	/**
	 * ArrayListΥ󥹥󥹤åäƤnull֤
	 * 
	 * @param value
	 * @return
	 */
	@SuppressWarnings("unchecked")
	private ArrayList checkArrayList(Object value){
		if(value instanceof ArrayList){
			boolean checkNull = true;
			ArrayList list = (ArrayList)value;
			for(int i = 0; i < list.size(); i++){
				if(checkString(list.get(i)) != null){
					list.set(i, checkString(list.get(i)));
					checkNull = false;
				}
				else if(checkInteger(list.get(i)) != null){
					list.set(i, checkInteger(list.get(i)));
					checkNull = false;
				}
				else{
					list.set(i, null);
				}
			}

			if(checkNull){
				list = null;
			}

			return list;
		}
		else{
			return null;
		}
	}
	
	/**
	 * 桼IDȤͭʸ󤫥å<p>
	 * ̵ʾ硢java.text.ParseException򥹥 
	 * 
	 * @param uid
	 * @throws ParseException
	 */
	private void checkValidUid(String uid) throws ParseException{
		
		char charData = '\u0000';
		
		// ͭ'A'-'Z','a'-'z','0'-'9'
		for (int i=0;i < uid.length();i++) {
			charData = uid.charAt(i);   
			if (((charData < 'A' )|| (charData > 'Z' )) &&
					((charData < 'a' ) || ( charData > 'z')) &&
					((charData < '0' ) || ( charData > '9'))) {
				throw new ParseException(uid, i);
			}
		}
	}
	
	/**
	 * ǧڥå幹
	 * 
	 */
	public void flushAuthenticationCache() {

		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptor
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectName
	        ObjectName name = new ObjectName(OBJECT_NAME);
	        
	        //ObjectNameOperationNameΥ᥽åɤ¹
	        Object[] args = {"hinemos"};
	        String[] signature = {String.class.getName()};
	        server.invoke(name, OPERATION_NAME, args, signature);

		} catch (NamingException e) {
			m_log.debug("flushAuthenticationCache() : " + e.getMessage());
		} catch (MalformedObjectNameException e) {
			m_log.debug("flushAuthenticationCache() : " + e.getMessage());
		} catch (NullPointerException e) {
			m_log.debug("flushAuthenticationCache() : " + e.getMessage());
		} catch (InstanceNotFoundException e) {
			m_log.debug("flushAuthenticationCache() : " + e.getMessage());
		} catch (MBeanException e) {
			m_log.debug("flushAuthenticationCache() : " + e.getMessage());
		} catch (ReflectionException e) {
			m_log.debug("flushAuthenticationCache() : " + e.getMessage());
		} catch (IOException e) {
			m_log.debug("flushAuthenticationCache() : " + e.getMessage());
		}
	}
}
