/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.jdbc2;

import java.sql.SQLException;
import java.util.Vector;
import org.postgresforest.core.Field;
import org.postgresforest.jdbc1.AbstractJdbc1ResultSetMetaData;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;

public abstract class AbstractJdbc2ResultSetMetaData
extends AbstractJdbc1ResultSetMetaData {
    public AbstractJdbc2ResultSetMetaData(Vector rows, Field[] fields) {
        super(rows, fields);
    }

    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return true;
    }

    public boolean isSearchable(int column) throws SQLException {
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case 1111: {
                return true;
            }
        }
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        String type_name = this.getField(column).getPGType();
        return type_name.equals("cash") || type_name.equals("money");
    }

    public int isNullable(int column) throws SQLException {
        return 2;
    }

    public boolean isSigned(int column) throws SQLException {
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        Field f = this.getField(column);
        String type_name = f.getPGType();
        int typmod = f.getMod();
        if (type_name.equals("int2")) {
            return 6;
        }
        if (type_name.equals("int4") || type_name.equals("oid")) {
            return 11;
        }
        if (type_name.equals("int8")) {
            return 20;
        }
        if (type_name.equals("money")) {
            return 12;
        }
        if (type_name.equals("float4")) {
            return 11;
        }
        if (type_name.equals("float8")) {
            return 20;
        }
        if (type_name.equals("char")) {
            return 1;
        }
        if (type_name.equals("bool")) {
            return 1;
        }
        if (type_name.equals("date")) {
            return 14;
        }
        if (type_name.equals("time")) {
            return 8;
        }
        if (type_name.equals("timestamp")) {
            return 22;
        }
        typmod -= 4;
        if (type_name.equals("bpchar") || type_name.equals("varchar")) {
            return typmod;
        }
        if (type_name.equals("numeric")) {
            return (typmod >> 16 & 0xFFFF) + 1 + (typmod & 0xFFFF);
        }
        return f.getLength();
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    public String getColumnName(int column) throws SQLException {
        Field f = this.getField(column);
        if (f != null) {
            return f.getName();
        }
        return "field" + column;
    }

    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field f = this.getField(column);
                if (f != null) {
                    return (0xFFFF0000 & f.getMod()) >> 16;
                }
                return 0;
            }
        }
        return 0;
    }

    public int getScale(int column) throws SQLException {
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case 5: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field f = this.getField(column);
                if (f != null) {
                    return (0xFFFF & f.getMod()) - 4;
                }
                return 0;
            }
        }
        return 0;
    }

    public String getTableName(int column) throws SQLException {
        return "";
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        return this.getField(column).getSQLType();
    }

    public String getColumnTypeName(int column) throws SQLException {
        return this.getField(column).getPGType();
    }

    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    private Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange", PSQLState.INVALID_PARAMETER_VALUE);
        }
        return this.fields[columnIndex - 1];
    }

    public String getColumnClassName(int column) throws SQLException {
        Field field = this.getField(column);
        int sql_type = field.getSQLType();
        switch (sql_type) {
            case -7: {
                return "java.lang.Boolean";
            }
            case 5: {
                return "java.lang.Short";
            }
            case 4: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 2: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 8: {
                return "java.lang.Double";
            }
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case -3: 
            case -2: {
                return "[B";
            }
            case 2003: {
                return "java.sql.Array";
            }
        }
        String type = field.getPGType();
        if ("unknown".equals(type)) {
            return "java.lang.String";
        }
        return "java.lang.Object";
    }
}

