/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.dao;

import com.clustercontrol.monitor.dao.StatusInfoDAO;
import com.clustercontrol.monitor.ejb.entity.StatusInfoBean;
import com.clustercontrol.monitor.ejb.entity.StatusInfoPK;
import com.clustercontrol.monitor.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatusInfoDAOImpl
implements StatusInfoDAO {
    protected static Log m_log = LogFactory.getLog(StatusInfoDAOImpl.class);

    public void init() {
    }

    public void load(StatusInfoPK pk, StatusInfoBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_status_info WHERE monitor_id = ? AND plugin_id = ? AND facility_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.monitorId);
                stmt.setString(2, pk.pluginId);
                stmt.setString(3, pk.facilityId);
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setMonitorId(res.getString("monitor_id"));
                    ejb.setPluginId(res.getString("plugin_id"));
                    ejb.setFacilityId(res.getString("facility_id"));
                    ejb.setOutputDate(res.getTimestamp("output_date"));
                    ejb.setGenerationDate(res.getTimestamp("generation_date"));
                    ejb.setApplication(res.getString("application"));
                    ejb.setMessageId(res.getString("message_id"));
                    ejb.setMessage(res.getString("message"));
                    ejb.setPriority(res.getInt("priority"));
                    ejb.setExpirationFlg(res.getInt("expiration_flg"));
                    ejb.setExpirationDate(res.getTimestamp("expiration_date"));
                    break block13;
                }
                String msg = "StatusInfo data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(StatusInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "UPDATE cc_status_info SET generation_date = ?, output_date = ?, application = ?, message_id = ?, message = ?, priority = ?, expiration_flg = ?, expiration_date = ? WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setTimestamp(1, ejb.getGenerationDate());
                stmt.setTimestamp(2, ejb.getOutputDate());
                stmt.setString(3, ejb.getApplication());
                stmt.setString(4, ejb.getMessageId());
                stmt.setString(5, ejb.getMessage());
                stmt.setInt(6, ejb.getPriority());
                stmt.setInt(7, ejb.getExpirationFlg());
                stmt.setTimestamp(8, ejb.getExpirationDate());
                stmt.setString(9, ejb.getPluginId());
                stmt.setString(10, ejb.getMonitorId());
                stmt.setString(11, ejb.getFacilityId());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException"));
                e.printStackTrace();
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException"));
                e1.printStackTrace();
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException"));
            e1.printStackTrace();
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId()));
    }

    public void remove(StatusInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_status_info WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.pluginId);
            stmt.setString(2, pk.monitorId);
            stmt.setString(3, pk.facilityId);
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public StatusInfoPK create(StatusInfoBean ejb) throws CreateException, EJBException {
        StatusInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "INSERT INTO cc_status_info (plugin_id, monitor_id, facility_id, output_date, generation_date, application, message_id, message, priority, expiration_flg, expiration_date)values (?,?,?,?,?,?,?,?,?,?,?)";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, ejb.getPluginId());
            stmt.setString(2, ejb.getMonitorId());
            stmt.setString(3, ejb.getFacilityId());
            stmt.setTimestamp(4, ejb.getOutputDate());
            stmt.setTimestamp(5, ejb.getGenerationDate());
            stmt.setString(6, ejb.getApplication());
            stmt.setString(7, ejb.getMessageId());
            stmt.setString(8, ejb.getMessage());
            stmt.setInt(9, ejb.getPriority());
            stmt.setInt(10, ejb.getExpirationFlg());
            stmt.setTimestamp(11, ejb.getExpirationDate());
            int row = stmt.executeUpdate();
            pk = new StatusInfoPK(ejb.getMonitorId(), ejb.getPluginId(), ejb.getFacilityId());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_status_info";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public StatusInfoPK findByPrimaryKey(StatusInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_status_info WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.pluginId);
            stmt.setString(2, pk.monitorId);
            stmt.setString(3, pk.facilityId);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            StatusInfoPK statusInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return statusInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    public Collection findHighPriorityStatus(String[] facilityId, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message) throws FinderException {
        m_log.debug((Object)"findHighPriorityStatus() start : ");
        ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuffer jbossQl = new StringBuffer();
            jbossQl.append("SELECT * FROM cc_status_info ");
            jbossQl.append("WHERE ");
            jbossQl.append("facility_id IN (");
            for (int index = 0; index < facilityId.length; ++index) {
                if (index != 0) {
                    jbossQl.append(",");
                }
                jbossQl.append("?");
            }
            jbossQl.append(")");
            if (outputFromDate != null) {
                jbossQl.append(" and output_date >= ?");
            }
            if (outputToDate != null) {
                jbossQl.append("and output_date <= ?");
            }
            if (generationFromDate != null) {
                jbossQl.append(" and generation_date >= ?");
            }
            if (generationToDate != null) {
                jbossQl.append(" and generation_date <= ?");
            }
            if (application != null && !"".equals(application)) {
                jbossQl.append(" and application like ?");
            }
            if (message != null && !"".equals(message)) {
                jbossQl.append(" and message like ?");
            }
            jbossQl.append(" ORDER BY priority, output_date DESC LIMIT 1");
            stmt = conn.prepareStatement(jbossQl.toString());
            int count = 1;
            if (facilityId != null && facilityId.length > 0) {
                for (int index = 0; index < facilityId.length; ++index) {
                    stmt.setString(count, facilityId[index]);
                    ++count;
                }
            }
            if (outputFromDate != null) {
                stmt.setTimestamp(count, outputFromDate);
                ++count;
            }
            if (outputToDate != null) {
                stmt.setTimestamp(count, outputToDate);
                ++count;
            }
            if (generationFromDate != null) {
                stmt.setTimestamp(count, generationFromDate);
                ++count;
            }
            if (generationToDate != null) {
                stmt.setTimestamp(count, generationToDate);
                ++count;
            }
            if (application != null && !"".equals(application)) {
                stmt.setString(count, "%" + application + "%");
                ++count;
            }
            if (message != null && !"".equals(message)) {
                stmt.setString(count, "%" + message + "%");
                ++count;
            }
            res = stmt.executeQuery();
            while (res.next()) {
                StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findHighPriorityStatus() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findHighPriorityStatus() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findHighPriorityStatus() end : ");
        return ret;
    }

    public Collection findStatus(String[] facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message) throws FinderException {
        m_log.debug((Object)"findStatus() start : ");
        ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuffer jbossQl = new StringBuffer();
            jbossQl.append("SELECT * FROM cc_status_info ");
            jbossQl.append("WHERE ");
            jbossQl.append("facility_id IN (");
            for (int index = 0; index < facilityId.length; ++index) {
                if (index != 0) {
                    jbossQl.append(",");
                }
                jbossQl.append("?");
            }
            jbossQl.append(")");
            if (priority != null) {
                jbossQl.append(" and priority = ?");
            }
            if (outputFromDate != null) {
                jbossQl.append(" and output_date >= ?");
            }
            if (outputToDate != null) {
                jbossQl.append(" and output_date <= ?");
            }
            if (generationFromDate != null) {
                jbossQl.append(" and generation_date >= ?");
            }
            if (generationToDate != null) {
                jbossQl.append(" and generation_date <= ?");
            }
            if (application != null && !"".equals(application)) {
                jbossQl.append(" and application like ?");
            }
            if (message != null && !"".equals(message)) {
                jbossQl.append(" and message like ?");
            }
            stmt = conn.prepareStatement(jbossQl.toString());
            int count = 1;
            if (facilityId != null && facilityId.length > 0) {
                for (int index = 0; index < facilityId.length; ++index) {
                    stmt.setString(count, facilityId[index]);
                    ++count;
                }
            }
            if (priority != null) {
                stmt.setInt(count, priority);
                ++count;
            }
            if (outputFromDate != null) {
                stmt.setTimestamp(count, outputFromDate);
                ++count;
            }
            if (outputToDate != null) {
                stmt.setTimestamp(count, outputToDate);
                ++count;
            }
            if (generationFromDate != null) {
                stmt.setTimestamp(count, generationFromDate);
                ++count;
            }
            if (generationToDate != null) {
                stmt.setTimestamp(count, generationToDate);
                ++count;
            }
            if (application != null && !"".equals(application)) {
                stmt.setString(count, "%" + application + "%");
                ++count;
            }
            if (message != null && !"".equals(message)) {
                stmt.setString(count, "%" + message + "%");
                ++count;
            }
            res = stmt.executeQuery();
            while (res.next()) {
                StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findStatus() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findStatus() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findStatus() end : ");
        return ret;
    }

    public Collection findExpirationStatus(Timestamp expirationDate) throws FinderException {
        m_log.debug((Object)"findExpirationStatus() start : ");
        ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuffer jbossQl = new StringBuffer();
            jbossQl.append("SELECT * FROM cc_status_info ");
            jbossQl.append("WHERE expiration_date <= ?");
            stmt = conn.prepareStatement(jbossQl.toString());
            stmt.setTimestamp(1, expirationDate);
            res = stmt.executeQuery();
            while (res.next()) {
                StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findExpirationStatus() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findExpirationStatus() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findExpirationStatus() end : ");
        return ret;
    }
}

