/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.dao;

import com.clustercontrol.monitor.dao.EventLogDAO;
import com.clustercontrol.monitor.ejb.entity.EventLogBean;
import com.clustercontrol.monitor.ejb.entity.EventLogPK;
import com.clustercontrol.monitor.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventLogDAOImpl
implements EventLogDAO {
    protected static Log m_log = LogFactory.getLog(EventLogDAOImpl.class);
    private static String INSERT_SQL = "INSERT INTO cc_event_log (plugin_id, monitor_id, facility_id, output_date, generation_date, scope_text, application, message_id, message, message_org, priority, confirm_flg, confirm_date, duplication_count, inhibited_flg )values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public void init() {
    }

    public void load(EventLogPK pk, EventLogBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_event_log WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.pluginId);
                stmt.setString(2, pk.monitorId);
                stmt.setString(3, pk.facilityId);
                stmt.setTimestamp(4, pk.outputDate);
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setPluginId(res.getString("plugin_id"));
                    ejb.setMonitorId(res.getString("monitor_id"));
                    ejb.setFacilityId(res.getString("facility_id"));
                    ejb.setOutputDate(res.getTimestamp("output_date"));
                    ejb.setGenerationDate(res.getTimestamp("generation_date"));
                    ejb.setScopeText(res.getString("scope_text"));
                    ejb.setApplication(res.getString("application"));
                    ejb.setMessageId(res.getString("message_id"));
                    ejb.setMessage(res.getString("message"));
                    ejb.setMessageOrg(res.getString("message_org"));
                    ejb.setPriority(res.getInt("priority"));
                    ejb.setConfirmFlg(res.getInt("confirm_flg"));
                    ejb.setConfirmDate(res.getTimestamp("confirm_date"));
                    ejb.setDuplicationCount(res.getInt("duplication_count"));
                    ejb.setInhibitedFlg(res.getInt("inhibited_flg"));
                    break block13;
                }
                String msg = "EventLog data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(EventLogBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "UPDATE cc_event_log SET generation_date = ?, scope_text = ?, application = ?, message_id = ?, message = ?, message_org = ?, priority = ?, confirm_flg = ?, confirm_date = ?, duplication_count = ?, inhibited_flg = ?WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setTimestamp(1, ejb.getGenerationDate());
                stmt.setString(2, ejb.getScopeText());
                stmt.setString(3, ejb.getApplication());
                stmt.setString(4, ejb.getMessageId());
                stmt.setString(5, ejb.getMessage());
                stmt.setString(6, ejb.getMessageOrg());
                stmt.setInt(7, ejb.getPriority());
                stmt.setInt(8, ejb.getConfirmFlg());
                stmt.setTimestamp(9, ejb.getConfirmDate());
                stmt.setInt(10, ejb.getDuplicationCount());
                stmt.setInt(11, ejb.getInhibitedFlg());
                stmt.setString(12, ejb.getPluginId());
                stmt.setString(13, ejb.getMonitorId());
                stmt.setString(14, ejb.getFacilityId());
                stmt.setTimestamp(15, ejb.getOutputDate());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
                e.printStackTrace();
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
                e1.printStackTrace();
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
            e1.printStackTrace();
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate()));
    }

    public void remove(EventLogPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_event_log WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.pluginId);
            stmt.setString(2, pk.monitorId);
            stmt.setString(3, pk.facilityId);
            stmt.setTimestamp(4, pk.outputDate);
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EventLogPK create(EventLogBean ejb) throws CreateException, EJBException {
        EventLogPK pk;
        m_log.debug((Object)("create() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "INSERT INTO cc_event_log (plugin_id, monitor_id, facility_id, output_date, generation_date, scope_text, application, message_id, message, message_org, priority, confirm_flg, confirm_date, duplication_count, inhibited_flg )values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, ejb.getPluginId());
                stmt.setString(2, ejb.getMonitorId());
                stmt.setString(3, ejb.getFacilityId());
                stmt.setTimestamp(4, ejb.getOutputDate());
                stmt.setTimestamp(5, ejb.getGenerationDate());
                stmt.setString(6, ejb.getScopeText());
                stmt.setString(7, ejb.getApplication());
                stmt.setString(8, ejb.getMessageId());
                stmt.setString(9, ejb.getMessage());
                stmt.setString(10, ejb.getMessageOrg());
                stmt.setInt(11, ejb.getPriority());
                stmt.setInt(12, ejb.getConfirmFlg());
                stmt.setTimestamp(13, ejb.getConfirmDate());
                stmt.setInt(14, ejb.getDuplicationCount());
                stmt.setInt(15, ejb.getInhibitedFlg());
                int row = stmt.executeUpdate();
                pk = new EventLogPK(ejb.getMonitorId(), ejb.getPluginId(), ejb.getFacilityId(), ejb.getOutputDate());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_event_log";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                EventLogPK pk = new EventLogPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"), res.getTimestamp("output_date"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public EventLogPK findByPrimaryKey(EventLogPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_event_log WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.pluginId);
            stmt.setString(2, pk.monitorId);
            stmt.setString(3, pk.facilityId);
            stmt.setTimestamp(4, pk.outputDate);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            EventLogPK eventLogPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return eventLogPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    public Collection findByGenerationDateOrder(String monitorId, String pluginId, String facilityId, Timestamp generationDate, Integer inhibitedFlg) throws FinderException {
        m_log.debug((Object)"findByGenerationDateOrder() start : ");
        ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_event_log WHERE monitor_id = ? and plugin_id = ? and facility_id = ? and generation_date <= ? and inhibited_flg = ? ORDER BY generation_date DESC, duplication_count LIMIT 1";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, monitorId);
            stmt.setString(2, pluginId);
            stmt.setString(3, facilityId);
            stmt.setTimestamp(4, generationDate);
            stmt.setInt(5, inhibitedFlg);
            res = stmt.executeQuery();
            while (res.next()) {
                EventLogPK pk = new EventLogPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"), res.getTimestamp("output_date"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findByGenerationDateOrder() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findByGenerationDateOrder() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findByGenerationDateOrder() end : ");
        return ret;
    }

    public Collection findByMessageOrg(String monitorId, String pluginId, String facilityId, Timestamp generationDate, String messageOrg) throws FinderException {
        m_log.debug((Object)"selectByMessageOrg() start : ");
        StringBuffer jbossQlWhere = new StringBuffer();
        jbossQlWhere.append(" plugin_id = ?");
        jbossQlWhere.append(" and monitor_id = ?");
        jbossQlWhere.append(" and facility_id = ?");
        jbossQlWhere.append(" and generation_date = ?");
        if (messageOrg != null) {
            jbossQlWhere.append(" and message_org = ?");
        } else {
            jbossQlWhere.append(" and message_org is null ");
        }
        ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM cc_event_log ");
            sql.append("WHERE " + jbossQlWhere.toString());
            sql.append(" ORDER BY output_date");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, pluginId);
            stmt.setString(2, monitorId);
            stmt.setString(3, facilityId);
            stmt.setTimestamp(4, generationDate);
            if (messageOrg != null) {
                stmt.setString(5, messageOrg);
            }
            res = stmt.executeQuery();
            while (res.next()) {
                EventLogPK pk = new EventLogPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"), res.getTimestamp("output_date"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"selectByMessageOrg() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"selectByMessageOrg() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"selectByMessageOrg() end : ");
        return ret;
    }

    public Collection findEvent(String[] facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message, Integer confirmFlg) throws FinderException {
        m_log.debug((Object)"selectEvent() start : ");
        StringBuffer jbossQlWhere = new StringBuffer();
        boolean whereFlg = false;
        if (facilityId != null && facilityId.length > 0) {
            jbossQlWhere.append("facility_id IN (");
            for (int index = 0; index < facilityId.length; ++index) {
                if (index != 0) {
                    jbossQlWhere.append(",");
                }
                jbossQlWhere.append("?");
            }
            jbossQlWhere.append(")");
            whereFlg = true;
        }
        if (priority != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " priority = ?");
            whereFlg = true;
        }
        if (outputFromDate != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date >= ?");
            whereFlg = true;
        }
        if (outputToDate != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date <= ?");
            whereFlg = true;
        }
        if (generationFromDate != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date >= ?");
            whereFlg = true;
        }
        if (generationToDate != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date <= ?");
            whereFlg = true;
        }
        if (application != null && !"".equals(application)) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " application like ?");
            whereFlg = true;
        }
        if (message != null && !"".equals(message)) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " message like ?");
            whereFlg = true;
        }
        if (confirmFlg != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " confirm_flg = ?");
            whereFlg = true;
        }
        ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM cc_event_log ");
            if (jbossQlWhere.length() > 0) {
                sql.append("WHERE " + jbossQlWhere.toString());
            }
            stmt = conn.prepareStatement(sql.toString());
            int count = 1;
            if (jbossQlWhere.length() > 0) {
                if (facilityId != null && facilityId.length > 0) {
                    for (int index = 0; index < facilityId.length; ++index) {
                        stmt.setString(count, facilityId[index]);
                        ++count;
                    }
                }
                if (priority != null) {
                    stmt.setInt(count, priority);
                    ++count;
                }
                if (outputFromDate != null) {
                    stmt.setTimestamp(count, outputFromDate);
                    ++count;
                }
                if (outputToDate != null) {
                    stmt.setTimestamp(count, outputToDate);
                    ++count;
                }
                if (generationFromDate != null) {
                    stmt.setTimestamp(count, generationFromDate);
                    ++count;
                }
                if (generationToDate != null) {
                    stmt.setTimestamp(count, generationToDate);
                    ++count;
                }
                if (application != null && !"".equals(application)) {
                    stmt.setString(count, "%" + application + "%");
                    ++count;
                }
                if (message != null && !"".equals(message)) {
                    stmt.setString(count, "%" + message + "%");
                    ++count;
                }
                if (confirmFlg != null) {
                    stmt.setInt(count, confirmFlg);
                    ++count;
                }
            }
            res = stmt.executeQuery();
            while (res.next()) {
                EventLogPK pk = new EventLogPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"), res.getTimestamp("output_date"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"selectEvent() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"selectEvent() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"selectEvent() end : ");
        return ret;
    }

    public int confirmEvent(String[] facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message, Integer beforConfirmFlg, Integer afterConfirmFlg) throws SQLException {
        int row;
        m_log.debug((Object)"confirmEvent() start : ");
        StringBuffer jbossQlWhere = new StringBuffer();
        boolean whereFlg = false;
        if (facilityId != null && facilityId.length > 0) {
            jbossQlWhere.append("facility_id IN (");
            for (int index = 0; index < facilityId.length; ++index) {
                if (index != 0) {
                    jbossQlWhere.append(",");
                }
                jbossQlWhere.append("?");
            }
            jbossQlWhere.append(")");
            whereFlg = true;
        }
        if (priority != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " priority = ?");
            whereFlg = true;
        }
        if (outputFromDate != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date >= ?");
            whereFlg = true;
        }
        if (outputToDate != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date <= ?");
            whereFlg = true;
        }
        if (generationFromDate != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date >= ?");
            whereFlg = true;
        }
        if (generationToDate != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date <= ?");
            whereFlg = true;
        }
        if (application != null && !"".equals(application)) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " application like ?");
            whereFlg = true;
        }
        if (message != null && !"".equals(message)) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " message like ?");
            whereFlg = true;
        }
        if (beforConfirmFlg != null) {
            jbossQlWhere.append(this.checkAndLogicalOperator(whereFlg) + " confirm_flg = ?");
            whereFlg = true;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE cc_event_log SET confirm_flg = ?, confirm_date = ? ");
            if (jbossQlWhere.length() > 0) {
                sql.append("WHERE " + jbossQlWhere.toString());
            }
            stmt = conn.prepareStatement(sql.toString());
            int count = 1;
            stmt.setInt(count++, afterConfirmFlg);
            stmt.setTimestamp(count++, new Timestamp(System.currentTimeMillis()));
            if (jbossQlWhere.length() > 0) {
                if (facilityId != null && facilityId.length > 0) {
                    for (int index = 0; index < facilityId.length; ++index) {
                        stmt.setString(count, facilityId[index]);
                        ++count;
                    }
                }
                if (priority != null) {
                    stmt.setInt(count, priority);
                    ++count;
                }
                if (outputFromDate != null) {
                    stmt.setTimestamp(count, outputFromDate);
                    ++count;
                }
                if (outputToDate != null) {
                    stmt.setTimestamp(count, outputToDate);
                    ++count;
                }
                if (generationFromDate != null) {
                    stmt.setTimestamp(count, generationFromDate);
                    ++count;
                }
                if (generationToDate != null) {
                    stmt.setTimestamp(count, generationToDate);
                    ++count;
                }
                if (application != null && !"".equals(application)) {
                    stmt.setString(count, "%" + application + "%");
                    ++count;
                }
                if (message != null && !"".equals(message)) {
                    stmt.setString(count, "%" + message + "%");
                    ++count;
                }
                if (beforConfirmFlg != null) {
                    stmt.setInt(count, beforConfirmFlg);
                    ++count;
                }
            }
            row = stmt.executeUpdate();
        }
        catch (SQLException e) {
            m_log.error((Object)"confirmEvent() error :  SQLException");
            m_log.error((Object)e.getMessage());
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"confirmEvent() error :  SQLException");
                m_log.error((Object)e1.getMessage());
                throw e1;
            }
        }
        m_log.debug((Object)"confirmEvent() end : ");
        return row;
    }

    public Collection findHighPriorityEvent(String[] facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message, Integer confirmFlg) throws FinderException {
        m_log.debug((Object)"selectHighPriorityEvent() start : ");
        ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuffer jbossQl = new StringBuffer();
            jbossQl.append("SELECT * FROM cc_event_log ");
            jbossQl.append("WHERE ");
            jbossQl.append("facility_id IN (");
            for (int index = 0; index < facilityId.length; ++index) {
                if (index != 0) {
                    jbossQl.append(",");
                }
                jbossQl.append("?");
            }
            jbossQl.append(")");
            if (priority != null) {
                jbossQl.append(" and priority = ?");
            }
            if (outputFromDate != null) {
                jbossQl.append(" and output_date >= ?");
            }
            if (outputToDate != null) {
                jbossQl.append("and output_date <= ?");
            }
            if (generationFromDate != null) {
                jbossQl.append(" and generation_date >= ?");
            }
            if (generationToDate != null) {
                jbossQl.append(" and generation_date <= ?");
            }
            if (application != null && !"".equals(application)) {
                jbossQl.append(" and application like ?");
            }
            if (message != null && !"".equals(message)) {
                jbossQl.append(" and message like ?");
            }
            if (confirmFlg != null) {
                jbossQl.append(" and confirm_flg = ?");
            }
            jbossQl.append(" ORDER BY priority, output_date DESC LIMIT 1");
            stmt = conn.prepareStatement(jbossQl.toString());
            int count = 1;
            if (facilityId != null && facilityId.length > 0) {
                for (int index = 0; index < facilityId.length; ++index) {
                    stmt.setString(count, facilityId[index]);
                    ++count;
                }
            }
            if (priority != null) {
                stmt.setInt(count, priority);
                ++count;
            }
            if (outputFromDate != null) {
                stmt.setTimestamp(count, outputFromDate);
                ++count;
            }
            if (outputToDate != null) {
                stmt.setTimestamp(count, outputToDate);
                ++count;
            }
            if (generationFromDate != null) {
                stmt.setTimestamp(count, generationFromDate);
                ++count;
            }
            if (generationToDate != null) {
                stmt.setTimestamp(count, generationToDate);
                ++count;
            }
            if (application != null && !"".equals(application)) {
                stmt.setString(count, "%" + application + "%");
                ++count;
            }
            if (message != null && !"".equals(message)) {
                stmt.setString(count, "%" + message + "%");
                ++count;
            }
            if (confirmFlg != null) {
                stmt.setInt(count, confirmFlg);
                ++count;
            }
            res = stmt.executeQuery();
            while (res.next()) {
                EventLogPK pk = new EventLogPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"), res.getTimestamp("output_date"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"selectHighPriorityEvent() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"selectHighPriorityEvent() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"selectHighPriorityEvent() start : ");
        return ret;
    }

    private String checkAndLogicalOperator(boolean flag) {
        if (flag) {
            return " and ";
        }
        return "";
    }
}

