/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.monitor.factory;

import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.SelectMonitorNumericValueType;
import com.clustercontrol.performanceMGR.ejb.bmp.Collector;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorHome;
import com.clustercontrol.performanceMGR.monitor.bean.MonitorPerfCheckInfo;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoPK;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectMonitorPerformance
extends SelectMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(SelectMonitorPerformance.class);

    public MonitorCheckInfo getCheckInfo() throws FinderException, NamingException {
        MonitorPerfInfoPK pk = new MonitorPerfInfoPK(this.m_monitorId, this.m_monitorTypeId);
        MonitorPerfInfoLocal perfLocal = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(pk);
        MonitorPerfCheckInfo perfCheck = new MonitorPerfCheckInfo();
        perfCheck.setMonitorTypeId(this.m_monitorTypeId);
        perfCheck.setMonitorId(this.m_monitorId);
        perfCheck.setCollectorId(perfLocal.getCollectorId());
        perfCheck.setItemCode(perfLocal.getItemCode());
        perfCheck.setDeviceIndex(perfLocal.getDeviceIndex());
        perfCheck.setDeviceName(perfLocal.getDeviceName());
        return perfCheck;
    }

    public ArrayList getMonitorListTableDefine(Locale local) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"monitor.id", (Locale)local), -1, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"description", (Locale)local), -1, 200, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"scope", (Locale)local), 2, 200, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"run.interval", (Locale)local), -1, 100, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"valid", (Locale)local) + "/" + Messages.getString((String)"invalid", (Locale)local), 4, 80, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)local), -1, 150, 16384));
        return tableDefine;
    }

    public MonitorInfo getMonitor(String monitorTypeId, String monitorId) throws CreateException, FinderException, NamingException {
        this.m_monitorTypeId = monitorTypeId;
        this.m_monitorId = monitorId;
        MonitorInfo bean = null;
        try {
            MonitorInfoPK pk = new MonitorInfoPK(this.m_monitorId, this.m_monitorTypeId);
            this.m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(pk);
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            String facilityPath = repository.getFacilityPath(this.m_monitor.getFacilityId(), null);
            bean = new MonitorInfo(this.m_monitor.getApplication(), null, this.m_monitor.getDescription(), null, facilityPath, this.m_monitor.getFacilityId(), this.m_monitor.getFailurePriority(), this.m_monitor.getMonitorBlock(), this.m_monitorId, this.m_monitorTypeId, this.m_monitor.getNotifyId(), this.m_monitor.getRegDate(), this.m_monitor.getRunInterval(), this.m_monitor.getUpdateDate(), this.getValid(this.m_monitorId, this.m_monitorTypeId), this.getJudgementInfo(), this.getCheckInfo());
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "getMonitor()", "010");
            e.printStackTrace();
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "getMonitor()", "010");
            e.printStackTrace();
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "getMonitor()", "010");
            e.printStackTrace();
            throw e;
        }
        return bean;
    }

    public ArrayList collectionToArray(Collection ct) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        ArrayList list = new ArrayList();
        for (MonitorInfoLocal monitor : ct) {
            String facilityPath = repository.getFacilityPath(monitor.getFacilityId(), null);
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(monitor.getMonitorId());
            info.add(monitor.getDescription());
            info.add(facilityPath);
            info.add(RunIntervalConstant.typeToString((int)monitor.getRunInterval()));
            info.add(this.getValid(monitor.getMonitorId(), monitor.getMonitorTypeId()));
            info.add(monitor.getUpdateDate() == null ? null : new Date(monitor.getUpdateDate().getTime()));
            list.add(info);
        }
        return list;
    }

    private int getValid(String monitorId, String monitorTypeId) throws FinderException, NamingException {
        MonitorPerfInfoPK perfPk = new MonitorPerfInfoPK(monitorId, monitorTypeId);
        MonitorPerfInfoLocal perfLocal = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(perfPk);
        String collectorId = perfLocal.getCollectorId();
        CollectorHome home = JNDIConnectionManager.getCollectorHome();
        try {
            Collection pks = home.findByCollectorType(3);
            int valid = -1;
            for (Collector collector : pks) {
                m_log.debug((Object)("getValid()  Monitor " + collector.getCollectorID() + " " + collector));
                if (!collectorId.equals(collector.getCollectorID()) || collector.getStatus() != 100) continue;
                return 1;
            }
            return 0;
        }
        catch (RemoteException e) {
            this.outputLog(e, "getValid()", "010");
            e.printStackTrace();
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "getValid()", "010");
            e.printStackTrace();
        }
        return -1;
    }

    private void outputLog(Exception e, String method, String index) {
        AplLogger apllog = new AplLogger("PERF", "perf");
        Object[] args = new String[]{this.m_monitorTypeId, this.m_monitorId};
        apllog.put("SYS", index, args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

