/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.swtcalendar;

import java.util.Calendar;
import java.util.Locale;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.vafada.swtcalendar.SWTCalendarEvent;
import org.vafada.swtcalendar.SWTCalendarListener;
import org.vafada.swtcalendar.SWTDayChooser;
import org.vafada.swtcalendar.SWTMonthChooser;
import org.vafada.swtcalendar.Spinner;

public class SWTCalendar
extends Composite {
    public static final int RED_SUNDAY = 0x1000000;
    public static final int RED_WEEKEND = 0x11000000;
    private boolean settingDate;
    private Spinner yearChooser;
    private SWTMonthChooser monthChooser;
    private SWTDayChooser dayChooser;
    private boolean settingYearMonth;

    public SWTCalendar(Composite parent, int style) {
        super(parent, style & 0xEE7FFFFF);
        Calendar calendar = Calendar.getInstance();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        this.setLayout((Layout)gridLayout);
        Composite header = new Composite((Composite)this, 0);
        GridData gridData = new GridData(768);
        header.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        header.setLayout((Layout)gridLayout2);
        Button prevMonthButton = new Button(header, 0x1004004 | style & 0x800000);
        prevMonthButton.setLayoutData((Object)new GridData(16));
        prevMonthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTCalendar.this.previousMonth();
            }
        });
        Composite composite = new Composite(header, 0);
        composite.setLayoutData((Object)new GridData(576));
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 2;
        gridLayout3.marginWidth = 0;
        gridLayout3.marginHeight = 0;
        composite.setLayout((Layout)gridLayout3);
        header.setTabList(new Control[]{composite});
        this.monthChooser = new SWTMonthChooser(composite);
        this.monthChooser.setLayoutData(new GridData(1040));
        this.monthChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SWTCalendar.this.settingYearMonth) {
                    SWTCalendar.this.dayChooser.setMonth(SWTCalendar.this.monthChooser.getMonth());
                }
            }
        });
        this.yearChooser = new Spinner(composite, 2048);
        this.yearChooser.setLayoutData(new GridData(16));
        this.yearChooser.setMinimum(1);
        this.yearChooser.setMaximum(9999);
        this.yearChooser.setValue(calendar.get(1));
        this.yearChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!SWTCalendar.this.settingYearMonth) {
                    SWTCalendar.this.dayChooser.setYear(SWTCalendar.this.yearChooser.getValue());
                }
            }
        });
        Button nextMonthButton = new Button(header, 0x1020004 | style & 0x800000);
        nextMonthButton.setLayoutData((Object)new GridData(16));
        nextMonthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTCalendar.this.nextMonth();
            }
        });
        this.dayChooser = new SWTDayChooser(this, 0x800 | style & 0x11000000);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.dayChooser.setLayoutData(gridData);
        this.dayChooser.addSWTCalendarListener(new SWTCalendarListener(){

            public void dateChanged(SWTCalendarEvent event) {
                SWTCalendar.this.refreshYearMonth(event.getCalendar());
            }
        });
        this.setTabList(new Control[]{header, this.dayChooser});
        this.setFont(parent.getFont());
    }

    public SWTCalendar(Composite parent) {
        this(parent, 0x800000);
    }

    public void setCalendar(Calendar cal) {
        this.settingDate = true;
        try {
            this.refreshYearMonth(cal);
            this.dayChooser.setCalendar(cal);
        }
        finally {
            this.settingDate = false;
        }
    }

    private void refreshYearMonth(Calendar cal) {
        this.settingYearMonth = true;
        this.yearChooser.setValue(cal.get(1));
        this.monthChooser.setMonth(cal.get(2));
        this.settingYearMonth = false;
    }

    public void nextMonth() {
        Calendar cal = this.dayChooser.getCalendar();
        cal.add(2, 1);
        this.refreshYearMonth(cal);
        this.dayChooser.setCalendar(cal);
    }

    public void previousMonth() {
        Calendar cal = this.dayChooser.getCalendar();
        cal.add(2, -1);
        this.refreshYearMonth(cal);
        this.dayChooser.setCalendar(cal);
    }

    public Calendar getCalendar() {
        return this.dayChooser.getCalendar();
    }

    public void addSWTCalendarListener(SWTCalendarListener listener) {
        this.dayChooser.addSWTCalendarListener(listener);
    }

    public void removeSWTCalendarListener(SWTCalendarListener listener) {
        this.dayChooser.removeSWTCalendarListener(listener);
    }

    public void setLocale(Locale locale) {
        this.monthChooser.setLocale(locale);
        this.dayChooser.setLocale(locale);
        this.yearChooser.setValue(this.getCalendar().get(1));
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.monthChooser.setFont(font);
        this.yearChooser.setFont(font);
        this.dayChooser.setFont(font);
    }

    public boolean isSettingDate() {
        return this.settingDate;
    }
}

