/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.server.LogStream;
import java.rmi.server.RMISocketFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.proxy.RMIDirectSocketFactory;
import sun.rmi.transport.proxy.RMIHttpToCGISocketFactory;
import sun.rmi.transport.proxy.RMIHttpToPortSocketFactory;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

public class RMIMasterSocketFactory
extends RMISocketFactory {
    static int logLevel = LogStream.parseLevel(RMIMasterSocketFactory.getLogLevel());
    static final Log proxyLog = Log.getLog("sun.rmi.transport.tcp.proxy", "transport", logLevel);
    private static long connectTimeout = RMIMasterSocketFactory.getConnectTimeout();
    private static final boolean eagerHttpFallback = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.transport.proxy.eagerHttpFallback"));
    private Hashtable successTable = new Hashtable();
    private static final int MaxRememberedHosts = 64;
    private Vector hostList = new Vector(64);
    protected RMISocketFactory initialFactory = new RMIDirectSocketFactory();
    protected Vector altFactoryList = new Vector(2);

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.proxy.logLevel"));
    }

    private static long getConnectTimeout() {
        return (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.proxy.connectTimeout", 15000L));
    }

    public RMIMasterSocketFactory() {
        boolean bl2 = false;
        try {
            Boolean bl3;
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
            if (string == null) {
                string = (String)AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
            }
            if (!(bl3 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.disableHttp"))).booleanValue() && string != null && string.length() > 0) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            bl2 = true;
        }
        if (bl2) {
            this.altFactoryList.addElement(new RMIHttpToPortSocketFactory());
            this.altFactoryList.addElement(new RMIHttpToCGISocketFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Socket createSocket(String string, int n2) throws IOException {
        int n3;
        Object object;
        Socket socket;
        RMISocketFactory rMISocketFactory;
        block50: {
            IOException iOException;
            AsyncConnector asyncConnector;
            Socket socket2;
            block51: {
                if (proxyLog.isLoggable(Log.BRIEF)) {
                    proxyLog.log(Log.BRIEF, "host: " + string + ", port: " + n2);
                }
                if (this.altFactoryList.size() == 0) {
                    return this.initialFactory.createSocket(string, n2);
                }
                rMISocketFactory = (RMISocketFactory)this.successTable.get(string);
                if (rMISocketFactory != null) {
                    if (!proxyLog.isLoggable(Log.BRIEF)) return rMISocketFactory.createSocket(string, n2);
                    proxyLog.log(Log.BRIEF, "previously successful factory found: " + rMISocketFactory);
                    return rMISocketFactory.createSocket(string, n2);
                }
                socket2 = null;
                socket = null;
                asyncConnector = new AsyncConnector(this.initialFactory, string, n2, AccessController.getContext());
                iOException = null;
                try {
                    try {
                        object = asyncConnector;
                        // MONITORENTER : object
                        Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(asyncConnector, "AsyncConnector", true));
                        thread.start();
                        try {
                            long l2 = System.currentTimeMillis();
                            long l3 = l2 + connectTimeout;
                            do {
                                asyncConnector.wait(l3 - l2);
                            } while ((socket2 = this.checkConnector(asyncConnector)) == null && (l2 = System.currentTimeMillis()) < l3);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new InterruptedIOException("interrupted while waiting for connector");
                        }
                        if (socket2 == null) {
                            throw new NoRouteToHostException("connect timed out: " + string);
                        }
                        proxyLog.log(Log.BRIEF, "direct socket connection successful");
                        object = socket2;
                        Object var16_21 = null;
                        if (iOException == null) return object;
                        if (proxyLog.isLoggable(Log.BRIEF)) {
                            proxyLog.log(Log.BRIEF, "direct socket connection failed: ", iOException);
                        }
                        n3 = 0;
                        break block50;
                    }
                    catch (UnknownHostException unknownHostException) {
                        iOException = unknownHostException;
                        Object var16_22 = null;
                        if (iOException == null) break block51;
                        if (proxyLog.isLoggable(Log.BRIEF)) {
                            proxyLog.log(Log.BRIEF, "direct socket connection failed: ", iOException);
                        }
                        for (int i2 = 0; i2 < this.altFactoryList.size(); ++i2) {
                            Object object22;
                            rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(i2);
                            try {
                                if (proxyLog.isLoggable(Log.BRIEF)) {
                                    proxyLog.log(Log.BRIEF, "trying with factory: " + rMISocketFactory);
                                }
                                object22 = rMISocketFactory.createSocket(string, n2);
                                InputStream inputStream = ((Socket)object22).getInputStream();
                                int n4 = inputStream.read();
                                ((Socket)object22).close();
                            }
                            catch (IOException object22) {
                                if (!proxyLog.isLoggable(Log.BRIEF)) continue;
                                proxyLog.log(Log.BRIEF, "factory failed: ", (Throwable)object22);
                                continue;
                            }
                            proxyLog.log(Log.BRIEF, "factory succeeded");
                            try {
                                socket = rMISocketFactory.createSocket(string, n2);
                            }
                            catch (IOException object22) {}
                            break;
                        }
                    }
                    catch (NoRouteToHostException noRouteToHostException) {
                        iOException = noRouteToHostException;
                        Object var16_23 = null;
                        if (iOException == null) break block51;
                        if (proxyLog.isLoggable(Log.BRIEF)) {
                            proxyLog.log(Log.BRIEF, "direct socket connection failed: ", iOException);
                        }
                        for (int i3 = 0; i3 < this.altFactoryList.size(); ++i3) {
                            Object object32;
                            block55: {
                                rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(i3);
                                try {}
                                catch (IOException object32) {
                                    if (!proxyLog.isLoggable(Log.BRIEF)) continue;
                                    proxyLog.log(Log.BRIEF, "factory failed: ", (Throwable)object32);
                                    continue;
                                }
                                if (!proxyLog.isLoggable(Log.BRIEF)) break block55;
                                proxyLog.log(Log.BRIEF, "trying with factory: " + rMISocketFactory);
                            }
                            object32 = rMISocketFactory.createSocket(string, n2);
                            InputStream inputStream = ((Socket)object32).getInputStream();
                            int n5 = inputStream.read();
                            ((Socket)object32).close();
                            proxyLog.log(Log.BRIEF, "factory succeeded");
                            try {}
                            catch (IOException object32) {}
                            socket = rMISocketFactory.createSocket(string, n2);
                            break;
                        }
                    }
                    catch (SocketException socketException) {
                        if (!eagerHttpFallback) throw socketException;
                        iOException = socketException;
                        Object var16_24 = null;
                        if (iOException == null) break block51;
                        if (proxyLog.isLoggable(Log.BRIEF)) {
                            proxyLog.log(Log.BRIEF, "direct socket connection failed: ", iOException);
                        }
                        for (int i4 = 0; i4 < this.altFactoryList.size(); ++i4) {
                            Object object42;
                            block56: {
                                rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(i4);
                                try {}
                                catch (IOException object42) {
                                    if (!proxyLog.isLoggable(Log.BRIEF)) continue;
                                    proxyLog.log(Log.BRIEF, "factory failed: ", (Throwable)object42);
                                    continue;
                                }
                                if (!proxyLog.isLoggable(Log.BRIEF)) break block56;
                                proxyLog.log(Log.BRIEF, "trying with factory: " + rMISocketFactory);
                            }
                            object42 = rMISocketFactory.createSocket(string, n2);
                            InputStream inputStream = ((Socket)object42).getInputStream();
                            int n6 = inputStream.read();
                            ((Socket)object42).close();
                            proxyLog.log(Log.BRIEF, "factory succeeded");
                            try {}
                            catch (IOException object42) {}
                            socket = rMISocketFactory.createSocket(string, n2);
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var16_25 = null;
                    if (iOException == null) throw throwable;
                    if (proxyLog.isLoggable(Log.BRIEF)) {
                        proxyLog.log(Log.BRIEF, "direct socket connection failed: ", iOException);
                    }
                    int n7 = 0;
                    while (n7 < this.altFactoryList.size()) {
                        block53: {
                            Object object52;
                            block57: {
                                rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(n7);
                                try {}
                                catch (IOException object52) {
                                    if (proxyLog.isLoggable(Log.BRIEF)) {
                                        proxyLog.log(Log.BRIEF, "factory failed: ", (Throwable)object52);
                                    }
                                    break block53;
                                }
                                if (!proxyLog.isLoggable(Log.BRIEF)) break block57;
                                proxyLog.log(Log.BRIEF, "trying with factory: " + rMISocketFactory);
                            }
                            object52 = rMISocketFactory.createSocket(string, n2);
                            InputStream inputStream = ((Socket)object52).getInputStream();
                            int n8 = inputStream.read();
                            ((Socket)object52).close();
                            proxyLog.log(Log.BRIEF, "factory succeeded");
                            try {}
                            catch (IOException object52) {
                                throw throwable;
                            }
                            socket = rMISocketFactory.createSocket(string, n2);
                            throw throwable;
                        }
                        ++n7;
                    }
                    throw throwable;
                }
            }
            Hashtable hashtable = this.successTable;
            // MONITORENTER : hashtable
            try {
                AsyncConnector asyncConnector2 = asyncConnector;
                // MONITORENTER : asyncConnector2
                socket2 = this.checkConnector(asyncConnector);
                // MONITOREXIT : asyncConnector2
                if (socket2 != null) {
                    if (socket != null) {
                        socket.close();
                    }
                    // MONITOREXIT : hashtable
                    return socket2;
                }
                asyncConnector.notUsed();
            }
            catch (UnknownHostException unknownHostException) {
                iOException = unknownHostException;
            }
            catch (NoRouteToHostException noRouteToHostException) {
                iOException = noRouteToHostException;
            }
            catch (SocketException socketException) {
                if (!eagerHttpFallback) throw socketException;
                iOException = socketException;
            }
            if (socket == null) throw iOException;
            this.rememberFactory(string, rMISocketFactory);
            // MONITOREXIT : hashtable
            return socket;
        }
        while (n3 < this.altFactoryList.size()) {
            block54: {
                Object object62;
                block58: {
                    rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(n3);
                    try {}
                    catch (IOException object62) {
                        if (proxyLog.isLoggable(Log.BRIEF)) {
                            proxyLog.log(Log.BRIEF, "factory failed: ", (Throwable)object62);
                        }
                        break block54;
                    }
                    if (!proxyLog.isLoggable(Log.BRIEF)) break block58;
                    proxyLog.log(Log.BRIEF, "trying with factory: " + rMISocketFactory);
                }
                object62 = rMISocketFactory.createSocket(string, n2);
                InputStream inputStream = ((Socket)object62).getInputStream();
                int n9 = inputStream.read();
                ((Socket)object62).close();
                proxyLog.log(Log.BRIEF, "factory succeeded");
                try {}
                catch (IOException object62) {
                    return object;
                }
                socket = rMISocketFactory.createSocket(string, n2);
                return object;
            }
            ++n3;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rememberFactory(String string, RMISocketFactory rMISocketFactory) {
        Hashtable hashtable = this.successTable;
        synchronized (hashtable) {
            while (this.hostList.size() >= 64) {
                this.successTable.remove(this.hostList.elementAt(0));
                this.hostList.removeElementAt(0);
            }
            this.hostList.addElement(string);
            this.successTable.put(string, rMISocketFactory);
        }
    }

    Socket checkConnector(AsyncConnector asyncConnector) throws IOException {
        Exception exception = asyncConnector.getException();
        if (exception != null) {
            exception.fillInStackTrace();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new Error("internal error: unexpected checked exception: " + exception.toString());
        }
        return asyncConnector.getSocket();
    }

    public ServerSocket createServerSocket(int n2) throws IOException {
        return this.initialFactory.createServerSocket(n2);
    }

    private class AsyncConnector
    implements Runnable {
        private RMISocketFactory factory;
        private String host;
        private int port;
        private AccessControlContext acc;
        private Exception exception = null;
        private Socket socket = null;
        private boolean cleanUp = false;

        AsyncConnector(RMISocketFactory rMISocketFactory, String string, int n2, AccessControlContext accessControlContext) {
            this.factory = rMISocketFactory;
            this.host = string;
            this.port = n2;
            this.acc = accessControlContext;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(string, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Socket socket = this.factory.createSocket(this.host, this.port);
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.socket = socket;
                    this.notify();
                }
                RMIMasterSocketFactory.this.rememberFactory(this.host, this.factory);
                asyncConnector = this;
                synchronized (asyncConnector) {
                    if (this.cleanUp) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.exception = exception;
                    this.notify();
                }
            }
        }

        private synchronized Exception getException() {
            return this.exception;
        }

        private synchronized Socket getSocket() {
            return this.socket;
        }

        synchronized void notUsed() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.cleanUp = true;
        }
    }
}

