/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.PrintStream;

public class ChunkedOutputStream
extends PrintStream {
    static final int DEFAULT_CHUNK_SIZE = 4096;
    private byte[] buf;
    private int count;
    private PrintStream out;
    private int preferredChunkSize;

    private int headerSize(int n2) {
        return 2 + Integer.toHexString(n2).length();
    }

    public ChunkedOutputStream(PrintStream printStream) {
        this(printStream, 4096);
    }

    public ChunkedOutputStream(PrintStream printStream, int n2) {
        super(printStream);
        this.out = printStream;
        if (n2 <= 0) {
            n2 = 4096;
        }
        if (n2 > 0) {
            int n3 = n2 - this.headerSize(n2);
            if (n3 + this.headerSize(n3) < n2) {
                ++n3;
            }
            n2 = n3;
        }
        this.preferredChunkSize = n2 > 0 ? n2 : 4096 - this.headerSize(4096);
        this.buf = new byte[this.preferredChunkSize + 32];
    }

    private void flush(boolean bl2) {
        int n2 = 0;
        do {
            int n3;
            if (this.count < this.preferredChunkSize) {
                if (!bl2) break;
                n3 = this.count;
            } else {
                n3 = this.preferredChunkSize;
            }
            byte[] byArray = Integer.toHexString(n3).getBytes();
            this.out.write(byArray, 0, byArray.length);
            this.out.write(13);
            this.out.write(10);
            if (n3 > 0) {
                this.out.write(this.buf, n2, n3);
                this.out.write(13);
                this.out.write(10);
            }
            this.out.flush();
            if (this.checkError()) break;
            if (n3 <= 0) continue;
            this.count -= n3;
            n2 += n3;
        } while (this.count > 0);
        if (!this.checkError()) {
            System.arraycopy(this.buf, n2, this.buf, 0, this.count);
        }
    }

    public boolean checkError() {
        return this.out.checkError();
    }

    private void checkFlush() {
        if (this.count >= this.preferredChunkSize) {
            this.flush(false);
        }
    }

    private void ensureOpen() {
        if (this.out == null) {
            this.setError();
        }
    }

    public synchronized void write(byte[] byArray, int n2, int n3) {
        this.ensureOpen();
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n4)];
            System.arraycopy(this.buf, 0, byArray2, 0, this.count);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n2, this.buf, this.count, n3);
        this.count = n4;
        this.checkFlush();
    }

    public synchronized void write(int n2) {
        this.ensureOpen();
        int n3 = this.count + 1;
        if (n3 > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n3)];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.buf[this.count] = (byte)n2;
        this.count = n3;
        this.checkFlush();
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public synchronized void close() {
        this.ensureOpen();
        if (this.count > 0) {
            this.flush(true);
        }
        this.flush(true);
        this.out = null;
    }

    public synchronized void flush() {
        this.ensureOpen();
        if (this.count > 0) {
            this.flush(true);
        }
    }
}

