/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.util.HashMap;
import java.util.Locale;
import sun.font.Font2D;
import sun.font.FontManager;

public class FontFamily {
    private static HashMap familyNameMap = new HashMap();
    private static HashMap allLocaleNames;
    protected String familyName;
    protected Font2D plain;
    protected Font2D bold;
    protected Font2D italic;
    protected Font2D bolditalic;
    protected boolean logicalFont = false;
    protected int familyRank;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontFamily getFamily(String string) {
        HashMap hashMap = familyNameMap;
        synchronized (hashMap) {
            return (FontFamily)familyNameMap.get(string.toLowerCase(Locale.ENGLISH));
        }
    }

    public static String[] getAllFamilyNames() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(Font2D font2D) {
        String string = font2D.getFamilyName(Locale.ENGLISH);
        FontFamily fontFamily = FontFamily.getFamily(string);
        if (fontFamily == null) {
            return;
        }
        if (fontFamily.plain == font2D) {
            fontFamily.plain = null;
        }
        if (fontFamily.bold == font2D) {
            fontFamily.bold = null;
        }
        if (fontFamily.italic == font2D) {
            fontFamily.italic = null;
        }
        if (fontFamily.bolditalic == font2D) {
            fontFamily.bolditalic = null;
        }
        if (fontFamily.plain == null && fontFamily.bold == null && fontFamily.plain == null && fontFamily.bold == null) {
            HashMap hashMap = familyNameMap;
            synchronized (hashMap) {
                familyNameMap.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontFamily(String string, boolean bl2, int n2) {
        this.logicalFont = bl2;
        this.familyName = string;
        this.familyRank = n2;
        HashMap hashMap = familyNameMap;
        synchronized (hashMap) {
            familyNameMap.put(string.toLowerCase(Locale.ENGLISH), this);
        }
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getRank() {
        return this.familyRank;
    }

    public void setFont(Font2D font2D, int n2) {
        if (font2D.getRank() > this.familyRank) {
            if (FontManager.logging) {
                FontManager.logger.warning("Rejecting adding " + font2D + " of lower rank " + font2D.getRank() + " to family " + this + " of rank " + this.familyRank);
            }
            return;
        }
        switch (n2) {
            case 0: {
                this.plain = font2D;
                break;
            }
            case 1: {
                this.bold = font2D;
                break;
            }
            case 2: {
                this.italic = font2D;
                break;
            }
            case 3: {
                this.bolditalic = font2D;
                break;
            }
        }
    }

    public Font2D getFontWithExactStyleMatch(int n2) {
        switch (n2) {
            case 0: {
                return this.plain;
            }
            case 1: {
                return this.bold;
            }
            case 2: {
                return this.italic;
            }
            case 3: {
                return this.bolditalic;
            }
        }
        return null;
    }

    public Font2D getFont(int n2) {
        switch (n2) {
            case 0: {
                return this.plain;
            }
            case 1: {
                if (this.bold != null) {
                    return this.bold;
                }
                if (this.plain != null && this.plain.canDoStyle(n2)) {
                    return this.plain;
                }
                return null;
            }
            case 2: {
                if (this.italic != null) {
                    return this.italic;
                }
                if (this.plain != null && this.plain.canDoStyle(n2)) {
                    return this.plain;
                }
                return null;
            }
            case 3: {
                if (this.bolditalic != null) {
                    return this.bolditalic;
                }
                if (this.italic != null && this.italic.canDoStyle(n2)) {
                    return this.italic;
                }
                if (this.bold != null && this.bold.canDoStyle(n2)) {
                    return this.italic;
                }
                if (this.plain != null && this.plain.canDoStyle(n2)) {
                    return this.plain;
                }
                return null;
            }
        }
        return null;
    }

    Font2D getClosestStyle(int n2) {
        switch (n2) {
            case 0: {
                if (this.bold != null) {
                    return this.bold;
                }
                if (this.italic != null) {
                    return this.italic;
                }
                return this.bolditalic;
            }
            case 1: {
                if (this.plain != null) {
                    return this.plain;
                }
                if (this.bolditalic != null) {
                    return this.bolditalic;
                }
                return this.italic;
            }
            case 2: {
                if (this.bolditalic != null) {
                    return this.bolditalic;
                }
                if (this.plain != null) {
                    return this.plain;
                }
                return this.bold;
            }
            case 3: {
                if (this.italic != null) {
                    return this.italic;
                }
                if (this.bold != null) {
                    return this.bold;
                }
                return this.plain;
            }
        }
        return null;
    }

    static synchronized void addLocaleNames(FontFamily fontFamily, String[] stringArray) {
        if (allLocaleNames == null) {
            allLocaleNames = new HashMap();
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            allLocaleNames.put(stringArray[i2].toLowerCase(), fontFamily);
        }
    }

    public static synchronized FontFamily getLocaleFamily(String string) {
        if (allLocaleNames == null) {
            return null;
        }
        return (FontFamily)allLocaleNames.get(string.toLowerCase());
    }

    public String toString() {
        return "Font family: " + this.familyName + " plain=" + this.plain + " bold=" + this.bold + " italic=" + this.italic + " bolditalic=" + this.bolditalic;
    }
}

