/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;

public class OffScreenImageSource
implements ImageProducer {
    BufferedImage image;
    int width;
    int height;
    Hashtable properties;
    private ImageConsumer theConsumer;

    public OffScreenImageSource(BufferedImage bufferedImage, Hashtable hashtable) {
        this.image = bufferedImage;
        this.properties = hashtable != null ? hashtable : new Hashtable();
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
    }

    public OffScreenImageSource(BufferedImage bufferedImage) {
        this(bufferedImage, null);
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.theConsumer = imageConsumer;
        this.produce();
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return imageConsumer == this.theConsumer;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.theConsumer == imageConsumer) {
            this.theConsumer = null;
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private void sendPixels() {
        int n2;
        Object object;
        ColorModel colorModel = this.image.getColorModel();
        WritableRaster writableRaster = this.image.getRaster();
        int n3 = writableRaster.getNumDataElements();
        int n4 = writableRaster.getDataBuffer().getDataType();
        int[] nArray = new int[this.width * n3];
        boolean bl2 = true;
        if (colorModel instanceof IndexColorModel) {
            int n5;
            object = new byte[this.width];
            this.theConsumer.setColorModel(colorModel);
            if (writableRaster instanceof ByteComponentRaster) {
                bl2 = false;
                for (n5 = 0; n5 < this.height; ++n5) {
                    writableRaster.getDataElements(0, n5, this.width, 1, object);
                    this.theConsumer.setPixels(0, n5, this.width, 1, colorModel, (byte[])object, 0, this.width);
                }
            } else if (writableRaster instanceof BytePackedRaster) {
                bl2 = false;
                for (n5 = 0; n5 < this.height; ++n5) {
                    writableRaster.getPixels(0, n5, this.width, 1, nArray);
                    for (n2 = 0; n2 < this.width; ++n2) {
                        object[n2] = (byte)nArray[n2];
                    }
                    this.theConsumer.setPixels(0, n5, this.width, 1, colorModel, (byte[])object, 0, this.width);
                }
            } else if (n4 == 2 || n4 == 3) {
                bl2 = false;
                for (n5 = 0; n5 < this.height; ++n5) {
                    writableRaster.getPixels(0, n5, this.width, 1, nArray);
                    this.theConsumer.setPixels(0, n5, this.width, 1, colorModel, nArray, 0, this.width);
                }
            }
        } else if (colorModel instanceof DirectColorModel) {
            this.theConsumer.setColorModel(colorModel);
            bl2 = false;
            switch (n4) {
                case 3: {
                    for (int i2 = 0; i2 < this.height; ++i2) {
                        writableRaster.getDataElements(0, i2, this.width, 1, nArray);
                        this.theConsumer.setPixels(0, i2, this.width, 1, colorModel, nArray, 0, this.width);
                    }
                    break;
                }
                case 0: {
                    byte[] byArray = new byte[this.width];
                    for (int i3 = 0; i3 < this.height; ++i3) {
                        writableRaster.getDataElements(0, i3, this.width, 1, byArray);
                        for (n2 = 0; n2 < this.width; ++n2) {
                            nArray[n2] = byArray[n2] & 0xFF;
                        }
                        this.theConsumer.setPixels(0, i3, this.width, 1, colorModel, nArray, 0, this.width);
                    }
                    break;
                }
                case 1: {
                    short[] sArray = new short[this.width];
                    for (n2 = 0; n2 < this.height; ++n2) {
                        writableRaster.getDataElements(0, n2, this.width, 1, sArray);
                        for (int i4 = 0; i4 < this.width; ++i4) {
                            nArray[i4] = sArray[i4] & 0xFFFF;
                        }
                        this.theConsumer.setPixels(0, n2, this.width, 1, colorModel, nArray, 0, this.width);
                    }
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            object = ColorModel.getRGBdefault();
            this.theConsumer.setColorModel((ColorModel)object);
            for (int i5 = 0; i5 < this.height; ++i5) {
                for (n2 = 0; n2 < this.width; ++n2) {
                    nArray[n2] = this.image.getRGB(n2, i5);
                }
                this.theConsumer.setPixels(0, i5, this.width, 1, (ColorModel)object, nArray, 0, this.width);
            }
        }
    }

    private void produce() {
        block2: {
            try {
                this.theConsumer.setDimensions(this.image.getWidth(), this.image.getHeight());
                this.theConsumer.setProperties(this.properties);
                this.sendPixels();
                this.theConsumer.imageComplete(2);
            }
            catch (NullPointerException nullPointerException) {
                if (this.theConsumer == null) break block2;
                this.theConsumer.imageComplete(1);
            }
        }
    }
}

