/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.awt.DebugHelper;
import sun.awt.FontConfiguration;
import sun.awt.X11GraphicsDevice;
import sun.awt.motif.MFontConfiguration;
import sun.font.FontManager;
import sun.font.NativeFont;
import sun.java2d.SunGraphicsEnvironment;
import sun.print.PSPrinterJob;
import sun.security.action.GetPropertyAction;

public class X11GraphicsEnvironment
extends SunGraphicsEnvironment {
    private static final DebugHelper dbg = DebugHelper.create(X11GraphicsEnvironment.class);
    static Boolean xinerState = null;
    private static HashSet<String> fontConfigDirs = null;
    private static Map fontNameMap = new HashMap();
    private static Map xFontDirsMap;
    private static Map xlfdMap;
    private static HashMap registeredDirs;
    private static String[] fontdirs;
    private static String display;
    private static boolean isDisplayLocal;
    HashMap<String, String> oblmap = null;
    private static final int FOUNDRY_FIELD = 1;
    private static final int FAMILY_NAME_FIELD = 2;
    private static final int WEIGHT_NAME_FIELD = 3;
    private static final int SLANT_FIELD = 4;
    private static final int SETWIDTH_NAME_FIELD = 5;
    private static final int ADD_STYLE_NAME_FIELD = 6;
    private static final int PIXEL_SIZE_FIELD = 7;
    private static final int POINT_SIZE_FIELD = 8;
    private static final int RESOLUTION_X_FIELD = 9;
    private static final int RESOLUTION_Y_FIELD = 10;
    private static final int SPACING_FIELD = 11;
    private static final int AVERAGE_WIDTH_FIELD = 12;
    private static final int CHARSET_REGISTRY_FIELD = 13;
    private static final int CHARSET_ENCODING_FIELD = 14;

    private static native int checkShmExt();

    private static native String getDisplayString();

    private static synchronized native void initDisplay();

    protected native int getNumScreens();

    protected GraphicsDevice makeScreenDevice(int n2) {
        return new X11GraphicsDevice(n2);
    }

    protected native int getDefaultScreenNum();

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreenNum()];
    }

    public static synchronized boolean isDisplayLocal() {
        if (display != null) {
            return isDisplayLocal;
        }
        if (X11GraphicsEnvironment.isHeadless()) {
            display = "";
            isDisplayLocal = true;
            return true;
        }
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.remote"));
        if (string != null) {
            display = "";
            isDisplayLocal = string.equals("false");
            return isDisplayLocal;
        }
        int n2 = X11GraphicsEnvironment.checkShmExt();
        if (n2 != -1) {
            display = "";
            isDisplayLocal = n2 == 1;
            return isDisplayLocal;
        }
        display = X11GraphicsEnvironment.getDisplayString();
        int n3 = display.indexOf(58);
        final String string2 = display.substring(0, n3);
        if (n3 <= 0) {
            isDisplayLocal = true;
            return true;
        }
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InetAddress[] inetAddressArray = null;
                Enumeration<InetAddress> enumeration = null;
                Enumeration<NetworkInterface> enumeration2 = null;
                try {
                    enumeration2 = NetworkInterface.getNetworkInterfaces();
                    inetAddressArray = InetAddress.getAllByName(string2);
                    if (inetAddressArray == null) {
                        return Boolean.FALSE;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Unknown host: " + string2);
                    return Boolean.FALSE;
                }
                catch (SocketException socketException) {
                    System.err.println(socketException.getMessage());
                    return Boolean.FALSE;
                }
                while (enumeration2.hasMoreElements()) {
                    enumeration = enumeration2.nextElement().getInetAddresses();
                    while (enumeration.hasMoreElements()) {
                        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
                            if (!((Object)enumeration.nextElement()).equals(inetAddressArray[i2])) continue;
                            return Boolean.TRUE;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        isDisplayLocal = bl2;
        return isDisplayLocal;
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new PSPrinterJob();
    }

    private String getObliqueLucidaFontID(String string) {
        if (string.startsWith("-lucidasans-medium-i-normal") || string.startsWith("-lucidasans-bold-i-normal") || string.startsWith("-lucidatypewriter-medium-i-normal") || string.startsWith("-lucidatypewriter-bold-i-normal")) {
            return string.substring(0, string.indexOf("-i-"));
        }
        return null;
    }

    private void initObliqueLucidaFontMap() {
        this.oblmap = new HashMap();
        this.oblmap.put("-lucidasans-medium", jreLibDirName + "/fonts/LucidaSansRegular.ttf");
        this.oblmap.put("-lucidasans-bold", jreLibDirName + "/fonts/LucidaSansDemiBold.ttf");
        this.oblmap.put("-lucidatypewriter-medium", jreLibDirName + "/fonts/LucidaTypewriterRegular.ttf");
        this.oblmap.put("-lucidatypewriter-bold", jreLibDirName + "/fonts/LucidaTypewriterBold.ttf");
    }

    public String getFileNameFromPlatformName(String string) {
        Vector vector;
        String string2 = null;
        String string3 = this.specificFontIDForName(string);
        string2 = super.getFileNameFromPlatformName(string);
        if (string2 != null) {
            if (X11GraphicsEnvironment.isHeadless() && string2.startsWith("-")) {
                return null;
            }
            if (string2.startsWith("/")) {
                vector = (Vector)xlfdMap.get(string2);
                if (vector == null) {
                    if (this.getFontConfiguration().needToSearchForFile(string2)) {
                        string2 = null;
                    }
                    if (string2 != null) {
                        vector = new Vector();
                        vector.add(string);
                        xlfdMap.put(string2, vector);
                    }
                } else if (!vector.contains(string)) {
                    vector.add(string);
                }
            }
            if (string2 != null) {
                fontNameMap.put(string3, string2);
                return string2;
            }
        }
        if (string3 != null) {
            string2 = (String)fontNameMap.get(string3);
            if (string2 == null && isLinux) {
                if (this.oblmap == null) {
                    this.initObliqueLucidaFontMap();
                }
                if ((vector = this.getObliqueLucidaFontID(string3)) != null) {
                    string2 = this.oblmap.get(vector);
                }
            }
            if (!(this.fontPath != null || string2 != null && string2.startsWith("/"))) {
                if (debugFonts) {
                    logger.warning("** Registering all font paths because can't find file for " + string);
                }
                this.fontPath = this.getPlatformFontPath(noType1Font);
                this.registerFontDirs(this.fontPath);
                if (debugFonts) {
                    logger.warning("** Finished registering all font paths");
                }
                string2 = (String)fontNameMap.get(string3);
            }
            if (string2 == null && !X11GraphicsEnvironment.isHeadless()) {
                string2 = X11GraphicsEnvironment.getX11FontName(string);
            }
            if (string2 == null) {
                string3 = this.switchFontIDForName(string);
                string2 = (String)fontNameMap.get(string3);
            }
            if (string2 != null) {
                fontNameMap.put(string3, string2);
            }
        }
        return string2;
    }

    private static String getX11FontName(String string) {
        String string2 = string.replaceAll("%d", "*");
        if (NativeFont.fontExists(string2)) {
            return string2;
        }
        return null;
    }

    public String getFileNameFromXLFD(String string) {
        String string2 = null;
        String string3 = this.specificFontIDForName(string);
        if (string3 != null) {
            string2 = (String)fontNameMap.get(string3);
            if (string2 == null) {
                string3 = this.switchFontIDForName(string);
                string2 = (String)fontNameMap.get(string3);
            }
            if (string2 == null) {
                string2 = this.getDefaultFontFile();
            }
        }
        return string2;
    }

    private String switchFontIDForName(String string) {
        int[] nArray = new int[14];
        int n2 = 1;
        int n3 = 1;
        while (n3 != -1 && n2 < 14) {
            if ((n3 = string.indexOf(45, n3)) == -1) continue;
            nArray[n2++] = n3++;
        }
        if (n2 != 14) {
            if (debugFonts) {
                logger.severe("Font Configuration Font ID is malformed:" + string);
            }
            return string;
        }
        String string2 = string.substring(nArray[3] + 1, nArray[4]);
        String string3 = string.substring(nArray[1] + 1, nArray[2]);
        String string4 = string.substring(nArray[12] + 1, nArray[13]);
        String string5 = string.substring(nArray[13] + 1);
        if (string2.equals("i")) {
            string2 = "o";
        } else if (string2.equals("o")) {
            string2 = "i";
        }
        if (string3.equals("itc zapfdingbats") && string4.equals("sun") && string5.equals("fontspecific")) {
            string4 = "adobe";
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(nArray[1], nArray[3] + 1));
        stringBuffer.append(string2);
        stringBuffer.append(string.substring(nArray[4], nArray[5] + 1));
        stringBuffer.append(string4);
        stringBuffer.append(string.substring(nArray[13]));
        String string6 = stringBuffer.toString().toLowerCase(Locale.ENGLISH);
        return string6;
    }

    private String specificFontIDForName(String string) {
        int[] nArray = new int[14];
        int n2 = 1;
        int n3 = 1;
        while (n3 != -1 && n2 < 14) {
            if ((n3 = string.indexOf(45, n3)) == -1) continue;
            nArray[n2++] = n3++;
        }
        if (n2 != 14) {
            if (debugFonts) {
                logger.severe("Font Configuration Font ID is malformed:" + string);
            }
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(nArray[1], nArray[5]));
        stringBuffer.append(string.substring(nArray[12]));
        String string2 = stringBuffer.toString().toLowerCase(Locale.ENGLISH);
        return string2;
    }

    protected String[] getNativeNames(String string, String string2) {
        Vector vector = (Vector)xlfdMap.get(string);
        if (vector == null) {
            if (string2 == null) {
                return null;
            }
            String[] stringArray = new String[]{string2};
            return stringArray;
        }
        int n2 = vector.size();
        return vector.toArray(new String[n2]);
    }

    protected void addFontToPlatformFontPath(String string) {
        String string2;
        String string3;
        if (xFontDirsMap != null && (string3 = (String)xFontDirsMap.get(string2 = this.specificFontIDForName(string))) != null) {
            fontConfigDirs.add(string3);
        }
    }

    protected void getPlatformFontPathFromFontConfig() {
        if (fontConfigDirs == null) {
            fontConfigDirs = this.getFontConfiguration().getAWTFontPathSet();
            if (debugFonts && fontConfigDirs != null) {
                String[] stringArray = fontConfigDirs.toArray(new String[0]);
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    logger.info("awtfontpath : " + stringArray[i2]);
                }
            }
        }
    }

    protected void registerPlatformFontsUsedByFontConfiguration() {
        if (fontConfigDirs == null) {
            return;
        }
        if (isLinux) {
            fontConfigDirs.add(jreLibDirName + File.separator + "oblique-fonts");
        }
        fontdirs = fontConfigDirs.toArray(new String[0]);
        fontConfigDirs = null;
        xFontDirsMap = null;
    }

    public static void setNativeFontPath() {
        if (fontdirs == null) {
            return;
        }
        for (int i2 = 0; i2 < fontdirs.length; ++i2) {
            if (debugFonts) {
                logger.info("Add " + fontdirs[i2] + " to X11 fontpath");
            }
            FontManager.setNativeFontPath(fontdirs[i2]);
        }
    }

    protected void registerFontDirs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || registeredDirs.containsKey(string2)) continue;
                registeredDirs.put(string2, null);
                this.registerFontDir(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerFontDir(String string) {
        block27: {
            if (debugFonts) {
                logger.info("ParseFontDir " + string);
            }
            File file = new File(string + File.separator + "fonts.dir");
            InputStreamReader inputStreamReader = null;
            try {
                if (!file.canRead()) break block27;
                inputStreamReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 8192);
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                streamTokenizer.eolIsSignificant(true);
                int n2 = streamTokenizer.nextToken();
                if (n2 == -2) {
                    int n3 = (int)streamTokenizer.nval;
                    n2 = streamTokenizer.nextToken();
                    if (n2 == 10) {
                        streamTokenizer.resetSyntax();
                        streamTokenizer.wordChars(32, 127);
                        streamTokenizer.wordChars(160, 255);
                        streamTokenizer.whitespaceChars(0, 31);
                        for (int i2 = 0; i2 < n3 && (n2 = streamTokenizer.nextToken()) != -1 && n2 == -3; ++i2) {
                            Serializable serializable;
                            int n4 = streamTokenizer.sval.indexOf(32);
                            if (n4 <= 0) {
                                ++n3;
                                n2 = streamTokenizer.nextToken();
                                if (n2 == 10) continue;
                                break;
                            }
                            if (streamTokenizer.sval.charAt(0) == '!') {
                                ++n3;
                                n2 = streamTokenizer.nextToken();
                                if (n2 == 10) continue;
                                break;
                            }
                            String string2 = streamTokenizer.sval.substring(0, n4);
                            int n5 = string2.lastIndexOf(58);
                            if (n5 > 0) {
                                if (n5 + 1 >= string2.length()) continue;
                                string2 = string2.substring(n5 + 1);
                            }
                            String string3 = streamTokenizer.sval.substring(n4 + 1);
                            String string4 = this.specificFontIDForName(string3);
                            String string5 = (String)fontNameMap.get(string4);
                            if (debugFonts) {
                                logger.info("file=" + string2 + " xlfd=" + string3);
                                logger.info("fontID=" + string4 + " sVal=" + string5);
                            }
                            String string6 = null;
                            try {
                                serializable = new File(string, string2);
                                if (xFontDirsMap == null) {
                                    xFontDirsMap = new HashMap();
                                }
                                xFontDirsMap.put(string4, string);
                                string6 = ((File)serializable).getCanonicalPath();
                            }
                            catch (IOException iOException) {
                                string6 = string + File.separator + string2;
                            }
                            serializable = (Vector)xlfdMap.get(string6);
                            if (debugFonts) {
                                logger.info("fullPath=" + string6 + " xVal=" + serializable);
                            }
                            if ((serializable == null || !((Vector)serializable).contains(string3)) && string5 == null || !string5.startsWith("/")) {
                                if (debugFonts) {
                                    logger.info("Map fontID:" + string4 + "to file:" + string6);
                                }
                                fontNameMap.put(string4, string6);
                                if (serializable == null) {
                                    serializable = new Vector();
                                    xlfdMap.put(string6, serializable);
                                }
                                ((Vector)serializable).add(string3);
                            }
                            if ((n2 = streamTokenizer.nextToken()) != 10) break;
                        }
                    }
                }
                inputStreamReader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected FontConfiguration createFontConfiguration() {
        return new MFontConfiguration(this);
    }

    public FontConfiguration createFontConfiguration(boolean bl2, boolean bl3) {
        return new MFontConfiguration(this, bl2, bl3);
    }

    public String getDefaultFontFaceName() {
        return null;
    }

    private static native boolean pRunningXinerama();

    private static native Point getXineramaCenterPoint();

    public Point getCenterPoint() {
        Point point;
        if (this.runningXinerama() && (point = X11GraphicsEnvironment.getXineramaCenterPoint()) != null) {
            return point;
        }
        return super.getCenterPoint();
    }

    public Rectangle getMaximumWindowBounds() {
        if (this.runningXinerama()) {
            return this.getXineramaWindowBounds();
        }
        return super.getMaximumWindowBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean runningXinerama() {
        if (xinerState != null) return xinerState;
        Class<X11GraphicsEnvironment> clazz = X11GraphicsEnvironment.class;
        synchronized (X11GraphicsEnvironment.class) {
            if (xinerState != null) return xinerState;
            xinerState = X11GraphicsEnvironment.pRunningXinerama();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return xinerState;
        }
    }

    protected Rectangle getXineramaWindowBounds() {
        Point point = this.getCenterPoint();
        GraphicsDevice[] graphicsDeviceArray = this.getScreenDevices();
        Rectangle rectangle = null;
        Rectangle rectangle2 = X11GraphicsEnvironment.getUsableBounds(graphicsDeviceArray[0]);
        for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
            Rectangle rectangle3 = X11GraphicsEnvironment.getUsableBounds(graphicsDeviceArray[i2]);
            if (rectangle == null && rectangle3.width / 2 + rectangle3.x > point.x - 1 && rectangle3.height / 2 + rectangle3.y > point.y - 1 && rectangle3.width / 2 + rectangle3.x < point.x + 1 && rectangle3.height / 2 + rectangle3.y < point.y + 1) {
                rectangle = rectangle3;
            }
            rectangle2 = rectangle2.union(rectangle3);
        }
        if (rectangle2.width / 2 + rectangle2.x > point.x - 1 && rectangle2.height / 2 + rectangle2.y > point.y - 1 && rectangle2.width / 2 + rectangle2.x < point.x + 1 && rectangle2.height / 2 + rectangle2.y < point.y + 1) {
            return rectangle2;
        }
        if (rectangle != null) {
            return rectangle;
        }
        return rectangle2;
    }

    static {
        xlfdMap = new HashMap();
        registeredDirs = new HashMap();
        fontdirs = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("awt");
                if (!GraphicsEnvironment.isHeadless()) {
                    X11GraphicsEnvironment.initDisplay();
                }
                return null;
            }
        });
        display = null;
        isDisplayLocal = false;
    }
}

