/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.XExposeEvent;
import sun.awt.X11.XWindow;

class XWarningWindow
extends XWindow {
    static final int defaultHeight = 27;
    Window ownerWindow;

    XWarningWindow(Window window, long l2) {
        super(window, l2);
        this.ownerWindow = window;
        this.xSetVisible(true);
        this.toFront();
    }

    protected String getWMName() {
        return "Warning window";
    }

    public Graphics getGraphics() {
        if (this.surfaceData == null || this.ownerWindow == null) {
            return null;
        }
        return this.getGraphics(this.surfaceData, this.getColor(), this.getBackground(), this.getFont());
    }

    void paint(Graphics graphics, int n2, int n3, int n4, int n5) {
        String string = this.getWarningString();
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        Rectangle rectangle2 = new Rectangle(n2, n3, n4, n5);
        if (rectangle2.intersects(rectangle)) {
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            graphics.setClip(rectangle3);
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            graphics.setColor(this.getColor());
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n6 = fontMetrics.stringWidth(string);
            int n7 = (rectangle.width - n6) / 2;
            int n8 = (rectangle.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2;
            graphics.drawString(string, n7, n8);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        }
    }

    String getWarningString() {
        return this.ownerWindow.getWarningString();
    }

    int getHeight() {
        return 27;
    }

    Color getBackground() {
        return SystemColor.window;
    }

    Color getColor() {
        return Color.black;
    }

    Font getFont() {
        return this.ownerWindow.getFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        Rectangle rectangle = this.getBounds();
        Graphics graphics = this.getGraphics();
        try {
            this.paint(graphics, 0, 0, rectangle.width, rectangle.height);
        }
        finally {
            graphics.dispose();
        }
    }

    public void handleExposeEvent(int n2, long l2) {
        super.handleExposeEvent(n2, l2);
        XExposeEvent xExposeEvent = new XExposeEvent(l2);
        final int n3 = xExposeEvent.get_x();
        final int n4 = xExposeEvent.get_y();
        final int n5 = xExposeEvent.get_width();
        final int n6 = xExposeEvent.get_height();
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Graphics graphics = XWarningWindow.this.getGraphics();
                try {
                    XWarningWindow.this.paint(graphics, n3, n4, n5, n6);
                }
                finally {
                    graphics.dispose();
                }
            }
        });
    }

    protected boolean isEventDisabled(IXAnyEvent iXAnyEvent) {
        return true;
    }
}

