/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.XAnyEvent;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDestroyWindowEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XMSelectionListener;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;

public class XMSelection {
    private static Logger log = Logger.getLogger("sun.awt.X11.XMSelection");
    String selectionName;
    Vector listeners;
    XAtom[] atoms;
    long[] owners;
    long eventMask;
    static int numScreens;
    static XAtom XA_MANAGER;
    static HashMap selectionMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initScreen(long l2, final int n2) {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            long l3 = XlibWrapper.RootWindow(l2, n2);
            XlibWrapper.XSelectInput(l2, l3, 131072L);
            XToolkit.addEventDispatcher(l3, new XEventDispatcher(){

                public void dispatchEvent(IXAnyEvent iXAnyEvent) {
                    XMSelection.processRootEvent((XAnyEvent)iXAnyEvent, n2);
                }
            });
        }
    }

    public int getNumberOfScreens() {
        return numScreens;
    }

    void select(long l2) {
        this.eventMask = l2;
        for (int i2 = 0; i2 < numScreens; ++i2) {
            this.selectPerScreen(i2, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetOwner(long l2, final int n2) {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            long l3 = XToolkit.getDisplay();
            XMSelection xMSelection = this;
            synchronized (xMSelection) {
                this.setOwner(l2, n2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("New Selection Owner for screen " + n2 + " = " + l2);
                }
                XlibWrapper.XSelectInput(l3, l2, 0x20000L | this.eventMask);
                XToolkit.addEventDispatcher(l2, new XEventDispatcher(){

                    public void dispatchEvent(IXAnyEvent iXAnyEvent) {
                        XMSelection.this.dispatchSelectionEvent(iXAnyEvent, n2);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectPerScreen(final int n2, long l2) {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            try {
                long l3 = XToolkit.getDisplay();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Grabbing XServer");
                }
                XlibWrapper.XGrabServer(l3);
                XMSelection xMSelection = this;
                synchronized (xMSelection) {
                    String string = this.getName() + "_S" + n2;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Screen = " + n2 + " selection name = " + string);
                    }
                    XAtom xAtom = XAtom.get(string);
                    selectionMap.put(new Long(xAtom.getAtom()), this);
                    this.setAtom(xAtom, n2);
                    long l4 = XlibWrapper.XGetSelectionOwner(l3, xAtom.getAtom());
                    if (l4 != 0L) {
                        this.setOwner(l4, n2);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Selection Owner for screen " + n2 + " = " + l4);
                        }
                        XlibWrapper.XSelectInput(l3, l4, 0x20000L | l2);
                        XToolkit.addEventDispatcher(l4, new XEventDispatcher(){

                            public void dispatchEvent(IXAnyEvent iXAnyEvent) {
                                XMSelection.this.dispatchSelectionEvent(iXAnyEvent, n2);
                            }
                        });
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("UnGrabbing XServer");
                }
                XlibWrapper.XUngrabServer(XToolkit.getDisplay());
            }
        }
    }

    static boolean processClientMessage(XClientMessageEvent xClientMessageEvent, int n2) {
        if (xClientMessageEvent.get_message_type() == XA_MANAGER.getAtom()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("client messags = " + xClientMessageEvent);
            }
            long l2 = xClientMessageEvent.get_data(0);
            long l3 = xClientMessageEvent.get_data(1);
            long l4 = xClientMessageEvent.get_data(2);
            long l5 = xClientMessageEvent.get_data(3);
            XMSelection xMSelection = XMSelection.getInstance(l3);
            if (xMSelection != null) {
                xMSelection.resetOwner(l4, n2);
                xMSelection.dispatchOwnerChangedEvent(xClientMessageEvent, n2, l4, l5, l2);
            }
        }
        return false;
    }

    static boolean processRootEvent(XAnyEvent xAnyEvent, int n2) {
        switch (xAnyEvent.get_type()) {
            case 33: {
                XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(xAnyEvent.pData);
                return XMSelection.processClientMessage(xClientMessageEvent, n2);
            }
        }
        return false;
    }

    static XMSelection getInstance(long l2) {
        return (XMSelection)selectionMap.get(new Long(l2));
    }

    public XMSelection(String string) {
        this(string, 0x400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMSelection(String string, long l2) {
        XMSelection xMSelection = this;
        synchronized (xMSelection) {
            this.selectionName = string;
            this.atoms = new XAtom[this.getNumberOfScreens()];
            this.owners = new long[this.getNumberOfScreens()];
        }
        this.select(l2);
    }

    public synchronized void addSelectionListener(XMSelectionListener xMSelectionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(xMSelectionListener);
    }

    public synchronized void removeSelectionListener(XMSelectionListener xMSelectionListener) {
        if (this.listeners == null) {
            this.listeners.remove(xMSelectionListener);
        }
    }

    synchronized Collection getListeners() {
        return this.listeners;
    }

    synchronized XAtom getAtom(int n2) {
        if (this.atoms != null) {
            return this.atoms[n2];
        }
        return null;
    }

    synchronized void setAtom(XAtom xAtom, int n2) {
        if (this.atoms != null) {
            this.atoms[n2] = xAtom;
        }
    }

    synchronized long getOwner(int n2) {
        if (this.owners != null) {
            return this.owners[n2];
        }
        return 0L;
    }

    synchronized void setOwner(long l2, int n2) {
        if (this.owners != null) {
            this.owners[n2] = l2;
        }
    }

    synchronized String getName() {
        return this.selectionName;
    }

    synchronized void dispatchSelectionChanged(XPropertyEvent xPropertyEvent, int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Selection Changed : Screen = " + n2 + "Event =" + xPropertyEvent);
        }
        if (this.listeners != null) {
            for (XMSelectionListener xMSelectionListener : this.listeners) {
                xMSelectionListener.selectionChanged(n2, this, xPropertyEvent.get_window(), xPropertyEvent);
            }
        }
    }

    synchronized void dispatchOwnerDeath(XDestroyWindowEvent xDestroyWindowEvent, int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Owner dead : Screen = " + n2 + "Event =" + xDestroyWindowEvent);
        }
        if (this.listeners != null) {
            for (XMSelectionListener xMSelectionListener : this.listeners) {
                xMSelectionListener.ownerDeath(n2, this, xDestroyWindowEvent.get_window());
            }
        }
    }

    void dispatchSelectionEvent(IXAnyEvent iXAnyEvent, int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Event =" + iXAnyEvent);
        }
        if (iXAnyEvent.get_type() == 17) {
            XDestroyWindowEvent xDestroyWindowEvent = new XDestroyWindowEvent(iXAnyEvent.getPData());
            this.dispatchOwnerDeath(xDestroyWindowEvent, n2);
        } else if (iXAnyEvent.get_type() == 28) {
            XPropertyEvent xPropertyEvent = new XPropertyEvent(iXAnyEvent.getPData());
            this.dispatchSelectionChanged(xPropertyEvent, n2);
        }
    }

    synchronized void dispatchOwnerChangedEvent(IXAnyEvent iXAnyEvent, int n2, long l2, long l3, long l4) {
        if (this.listeners != null) {
            for (XMSelectionListener xMSelectionListener : this.listeners) {
                xMSelectionListener.ownerChanged(n2, this, l2, l3, l4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long l2 = XToolkit.getDisplay();
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            numScreens = XlibWrapper.ScreenCount(l2);
        }
        XA_MANAGER = XAtom.get("MANAGER");
        for (int i2 = 0; i2 < numScreens; ++i2) {
            XMSelection.initScreen(l2, i2);
        }
        selectionMap = new HashMap();
    }
}

