/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.io.IOException;
import java.util.HashMap;
import sun.awt.X11.MotifDnDConstants;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDropTargetProtocolListener;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;

abstract class XDropTargetProtocol {
    private final XDropTargetProtocolListener listener;
    public static final int EMBEDDER_ALREADY_REGISTERED = 0;
    public static final int UNKNOWN_MESSAGE = 0;
    public static final int ENTER_MESSAGE = 1;
    public static final int MOTION_MESSAGE = 2;
    public static final int LEAVE_MESSAGE = 3;
    public static final int DROP_MESSAGE = 4;
    private boolean motionPassedAlong = false;
    private final HashMap embedderRegistry = new HashMap();

    protected XDropTargetProtocol(XDropTargetProtocolListener xDropTargetProtocolListener) {
        if (xDropTargetProtocolListener == null) {
            throw new NullPointerException("Null XDropTargetProtocolListener");
        }
        this.listener = xDropTargetProtocolListener;
    }

    protected final XDropTargetProtocolListener getProtocolListener() {
        return this.listener;
    }

    public abstract void registerDropTarget(long var1);

    public abstract void unregisterDropTarget(long var1);

    public abstract void registerEmbedderDropSite(long var1);

    public abstract void unregisterEmbedderDropSite(long var1);

    public abstract boolean isProtocolSupported(long var1);

    public abstract int getMessageType(XClientMessageEvent var1);

    public final boolean processClientMessage(XClientMessageEvent xClientMessageEvent) {
        int n2 = this.getMessageType(xClientMessageEvent);
        boolean bl2 = this.processClientMessageImpl(xClientMessageEvent);
        this.postProcessClientMessage(xClientMessageEvent, bl2, n2);
        return bl2;
    }

    protected abstract boolean processClientMessageImpl(XClientMessageEvent var1);

    protected final boolean forwardClientMessageToToplevel(long l2, XClientMessageEvent xClientMessageEvent) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        EmbedderRegistryEntry embedderRegistryEntry = this.getEmbedderRegistryEntry(l2);
        if (embedderRegistryEntry == null) {
            return false;
        }
        if (!embedderRegistryEntry.isOverriden()) {
            return false;
        }
        this.adjustEventForForwarding(xClientMessageEvent, embedderRegistryEntry);
        long l3 = embedderRegistryEntry.getProxy();
        if (l3 == 0L) {
            l3 = l2;
        }
        XlibWrapper.XSendEvent(XToolkit.getDisplay(), l3, false, 0L, xClientMessageEvent.pData);
        return true;
    }

    protected abstract void sendEnterMessageToToplevel(long var1, XClientMessageEvent var3);

    protected abstract void sendLeaveMessageToToplevel(long var1, XClientMessageEvent var3);

    private void postProcessClientMessage(XClientMessageEvent xClientMessageEvent, boolean bl2, int n2) {
        long l2 = xClientMessageEvent.get_window();
        if (this.getEmbedderRegistryEntry(l2) != null) {
            if (!bl2) {
                this.forwardClientMessageToToplevel(l2, xClientMessageEvent);
            } else {
                boolean bl3 = xClientMessageEvent.get_message_type() == MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom();
                switch (n2) {
                    case 2: {
                        if (!this.isDragOverComponent()) {
                            if (!this.motionPassedAlong && !bl3) {
                                this.sendEnterMessageToToplevel(l2, xClientMessageEvent);
                            }
                            this.forwardClientMessageToToplevel(l2, xClientMessageEvent);
                            this.motionPassedAlong = true;
                            break;
                        }
                        if (this.motionPassedAlong && !bl3) {
                            this.sendLeaveMessageToToplevel(l2, xClientMessageEvent);
                        }
                        this.motionPassedAlong = false;
                        break;
                    }
                    case 4: {
                        if (!this.isDragOverComponent()) {
                            this.forwardClientMessageToToplevel(l2, xClientMessageEvent);
                        }
                        this.motionPassedAlong = false;
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (bl3) {
                            this.forwardClientMessageToToplevel(l2, xClientMessageEvent);
                        }
                        this.motionPassedAlong = false;
                    }
                }
            }
        }
    }

    public abstract boolean sendResponse(long var1, int var3, int var4);

    public abstract Object getData(long var1, long var3) throws IllegalArgumentException, IOException;

    public abstract boolean sendDropDone(long var1, boolean var3, int var4);

    public abstract long getSourceWindow();

    public abstract void cleanup();

    public abstract boolean isDragOverComponent();

    public void adjustEventForForwarding(XClientMessageEvent xClientMessageEvent, EmbedderRegistryEntry embedderRegistryEntry) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void putEmbedderRegistryEntry(long l2, boolean bl2, int n2, long l3) {
        XDropTargetProtocol xDropTargetProtocol = this;
        synchronized (xDropTargetProtocol) {
            this.embedderRegistry.put(new Long(l2), new EmbedderRegistryEntry(bl2, n2, l3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final EmbedderRegistryEntry getEmbedderRegistryEntry(long l2) {
        XDropTargetProtocol xDropTargetProtocol = this;
        synchronized (xDropTargetProtocol) {
            return (EmbedderRegistryEntry)this.embedderRegistry.get(new Long(l2));
        }
    }

    protected static final class EmbedderRegistryEntry {
        private final boolean overriden;
        private final int version;
        private final long proxy;

        EmbedderRegistryEntry(boolean bl2, int n2, long l2) {
            this.overriden = bl2;
            this.version = n2;
            this.proxy = l2;
        }

        public boolean isOverriden() {
            return this.overriden;
        }

        public int getVersion() {
            return this.version;
        }

        public long getProxy() {
            return this.proxy;
        }
    }
}

