/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class DefaultPreviewPanel
extends JPanel {
    private int squareSize = 25;
    private int squareGap = 5;
    private int innerGap = 5;
    private int textGap = 5;
    private Font font = new Font("Dialog", 0, 12);
    private String sampleText = UIManager.getString("ColorChooser.sampleText");
    private int swatchWidth = 50;
    private Color oldColor = null;

    DefaultPreviewPanel() {
    }

    private JColorChooser getColorChooser() {
        return (JColorChooser)SwingUtilities.getAncestorOfClass(JColorChooser.class, this);
    }

    public Dimension getPreferredSize() {
        JComponent jComponent = this.getColorChooser();
        if (jComponent == null) {
            jComponent = this;
        }
        FontMetrics fontMetrics = jComponent.getFontMetrics(this.getFont());
        int n2 = fontMetrics.getAscent();
        int n3 = fontMetrics.getHeight();
        int n4 = SwingUtilities2.stringWidth(jComponent, fontMetrics, this.sampleText);
        int n5 = n3 * 3 + this.textGap * 3;
        int n6 = this.squareSize * 3 + this.squareGap * 2 + this.swatchWidth + n4 + this.textGap * 3;
        return new Dimension(n6, n5);
    }

    public void paintComponent(Graphics graphics) {
        if (this.oldColor == null) {
            this.oldColor = this.getForeground();
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getComponentOrientation().isLeftToRight()) {
            int n2 = this.paintSquares(graphics, 0);
            int n3 = this.paintText(graphics, n2);
            this.paintSwatch(graphics, n2 + n3);
        } else {
            int n4 = this.paintSwatch(graphics, 0);
            int n5 = this.paintText(graphics, n4);
            this.paintSquares(graphics, n4 + n5);
        }
    }

    private int paintSwatch(Graphics graphics, int n2) {
        int n3 = n2;
        graphics.setColor(this.oldColor);
        graphics.fillRect(n3, 0, this.swatchWidth, this.squareSize + this.squareGap / 2);
        graphics.setColor(this.getForeground());
        graphics.fillRect(n3, this.squareSize + this.squareGap / 2, this.swatchWidth, this.squareSize + this.squareGap / 2);
        return n3 + this.swatchWidth;
    }

    private int paintText(Graphics graphics, int n2) {
        graphics.setFont(this.getFont());
        JComponent jComponent = this.getColorChooser();
        if (jComponent == null) {
            jComponent = this;
        }
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.getHeight();
        int n5 = SwingUtilities2.stringWidth(jComponent, fontMetrics, this.sampleText);
        int n6 = n2 + this.textGap;
        Color color = this.getForeground();
        graphics.setColor(color);
        SwingUtilities2.drawString(jComponent, graphics, this.sampleText, n6 + this.textGap / 2, n3 + 2);
        graphics.fillRect(n6, n4 + this.textGap, n5 + this.textGap, n4 + 2);
        graphics.setColor(Color.black);
        SwingUtilities2.drawString(jComponent, graphics, this.sampleText, n6 + this.textGap / 2, n4 + n3 + this.textGap + 2);
        graphics.setColor(Color.white);
        graphics.fillRect(n6, (n4 + this.textGap) * 2, n5 + this.textGap, n4 + 2);
        graphics.setColor(color);
        SwingUtilities2.drawString(jComponent, graphics, this.sampleText, n6 + this.textGap / 2, (n4 + this.textGap) * 2 + n3 + 2);
        return n5 + this.textGap * 3;
    }

    private int paintSquares(Graphics graphics, int n2) {
        int n3 = n2;
        Color color = this.getForeground();
        graphics.setColor(Color.white);
        graphics.fillRect(n3, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(n3 + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.setColor(Color.white);
        graphics.fillRect(n3 + this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        graphics.setColor(color);
        graphics.fillRect(n3, this.squareSize + this.squareGap, this.squareSize, this.squareSize);
        graphics.translate(this.squareSize + this.squareGap, 0);
        graphics.setColor(Color.black);
        graphics.fillRect(n3, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(n3 + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.setColor(Color.white);
        graphics.fillRect(n3 + this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        graphics.translate(-(this.squareSize + this.squareGap), 0);
        graphics.translate(this.squareSize + this.squareGap, this.squareSize + this.squareGap);
        graphics.setColor(Color.white);
        graphics.fillRect(n3, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(n3 + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.translate(-(this.squareSize + this.squareGap), -(this.squareSize + this.squareGap));
        graphics.translate((this.squareSize + this.squareGap) * 2, 0);
        graphics.setColor(Color.white);
        graphics.fillRect(n3, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(n3 + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.setColor(Color.black);
        graphics.fillRect(n3 + this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        graphics.translate(-((this.squareSize + this.squareGap) * 2), 0);
        graphics.translate((this.squareSize + this.squareGap) * 2, this.squareSize + this.squareGap);
        graphics.setColor(Color.black);
        graphics.fillRect(n3, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(n3 + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.translate(-((this.squareSize + this.squareGap) * 2), -(this.squareSize + this.squareGap));
        return this.squareSize * 3 + this.squareGap * 2;
    }
}

